/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.model.kv.Value;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class KVCache
extends ConsulCache<String, Value> {
    private KVCache(Function<Value, String> keyConversion, ConsulCache.CallbackConsumer<Value> callbackConsumer) {
        super(keyConversion, callbackConsumer);
    }

    public static KVCache newCache(final KeyValueClient kvClient, final String rootPath, final int watchSeconds) {
        final LinkedHashSet<String> rootPathSegments = new LinkedHashSet<String>(Arrays.asList(rootPath.split("/")));
        Function<Value, String> keyExtractor = new Function<Value, String>(){

            public String apply(Value input) {
                LinkedHashSet<String> inputPathSegments = new LinkedHashSet<String>(Arrays.asList(input.getKey().split("/")));
                return StringUtils.join((Iterable)Sets.difference(inputPathSegments, (Set)rootPathSegments), (String)"/");
            }
        };
        ConsulCache.CallbackConsumer<Value> callbackConsumer = new ConsulCache.CallbackConsumer<Value>(){

            @Override
            public void consume(BigInteger index, ConsulResponseCallback<List<Value>> callback) {
                kvClient.getValues(rootPath, ConsulCache.watchParams(index, watchSeconds), callback);
            }
        };
        return new KVCache(keyExtractor, callbackConsumer);
    }
}

