/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.retrofit.converter.jackson;

import com.orbitz.fasterxml.jackson.databind.JavaType;
import com.orbitz.fasterxml.jackson.databind.ObjectMapper;
import com.orbitz.fasterxml.jackson.databind.ObjectReader;
import com.orbitz.fasterxml.jackson.databind.ObjectWriter;
import com.orbitz.okhttp3.RequestBody;
import com.orbitz.okhttp3.ResponseBody;
import com.orbitz.retrofit.Converter;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.converter.jackson.JacksonRequestBodyConverter;
import com.orbitz.retrofit.converter.jackson.JacksonResponseBodyConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public final class JacksonConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        this.mapper = mapper;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.reader(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerWithType(javaType);
        return new JacksonRequestBodyConverter(writer);
    }
}

