/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.okio;

import com.orbitz.okio.Buffer;
import com.orbitz.okio.ByteString;
import com.orbitz.okio.ForwardingSource;
import com.orbitz.okio.Segment;
import com.orbitz.okio.Source;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashingSource
extends ForwardingSource {
    private final MessageDigest messageDigest;

    public static HashingSource md5(Source source) {
        return new HashingSource(source, "MD5");
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, "SHA-1");
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, "SHA-256");
    }

    private HashingSource(Source source, String algorithm) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    @Override
    public long read(Buffer sink, long byteCount) throws IOException {
        long result = super.read(sink, byteCount);
        if (result != -1L) {
            long offset;
            long start = sink.size - result;
            Segment s = sink.head;
            for (offset = sink.size; offset > sink.size - result; offset -= (long)(s.limit - s.pos)) {
                s = s.prev;
            }
            while (offset < sink.size) {
                int pos = (int)((long)s.pos + start - offset);
                this.messageDigest.update(s.data, pos, s.limit - pos);
                start = offset += (long)(s.limit - s.pos);
            }
        }
        return result;
    }

    public ByteString hash() {
        byte[] result = this.messageDigest.digest();
        return ByteString.of(result);
    }
}

