/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.orbitz.consul.option.ConsistencyMode;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.ArrayList;

public final class ImmutableQueryOptions
extends QueryOptions {
    private final Optional<String> wait;
    private final Optional<String> token;
    private final Optional<BigInteger> index;
    private final Optional<String> near;
    private final ConsistencyMode consistencyMode;
    private final boolean isBlocking;
    private final boolean hasToken;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableQueryOptions(Builder builder) {
        this.wait = builder.wait;
        this.token = builder.token;
        this.index = builder.index;
        this.near = builder.near;
        if (builder.consistencyMode != null) {
            this.initShim.consistencyMode(builder.consistencyMode);
        }
        this.consistencyMode = this.initShim.getConsistencyMode();
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.initShim = null;
    }

    private ImmutableQueryOptions(Optional<String> wait, Optional<String> token, Optional<BigInteger> index, Optional<String> near, ConsistencyMode consistencyMode) {
        this.wait = wait;
        this.token = token;
        this.index = index;
        this.near = near;
        this.consistencyMode = consistencyMode;
        this.initShim.consistencyMode(consistencyMode);
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.initShim = null;
    }

    @Override
    public Optional<String> getWait() {
        return this.wait;
    }

    @Override
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    public Optional<BigInteger> getIndex() {
        return this.index;
    }

    @Override
    public Optional<String> getNear() {
        return this.near;
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        return this.initShim != null ? this.initShim.getConsistencyMode() : this.consistencyMode;
    }

    @Override
    public boolean isBlocking() {
        return this.initShim != null ? this.initShim.isBlocking() : this.isBlocking;
    }

    @Override
    public boolean hasToken() {
        return this.initShim != null ? this.initShim.hasToken() : this.hasToken;
    }

    public final ImmutableQueryOptions withWait(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.wait.equals((Object)newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions((Optional<String>)newValue, this.token, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWait(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"wait");
        if (this.wait.equals((Object)value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions((Optional<String>)value, this.token, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.token.equals((Object)newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, (Optional<String>)newValue, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"token");
        if (this.token.equals((Object)value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, (Optional<String>)value, this.index, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(BigInteger value) {
        Optional newValue = Optional.of((Object)value);
        if (this.index.isPresent() && this.index.get() == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, (Optional<BigInteger>)newValue, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(Optional<BigInteger> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"index");
        if (!this.index.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.index.isPresent() && value.isPresent() && this.index.get() == value.get()) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, (Optional<BigInteger>)value, this.near, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.near.equals((Object)newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, (Optional<String>)newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"near");
        if (this.near.equals((Object)value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, (Optional<String>)value, this.consistencyMode));
    }

    public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"consistencyMode"))));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryOptions && this.equalTo((ImmutableQueryOptions)another);
    }

    private boolean equalTo(ImmutableQueryOptions another) {
        return this.wait.equals(another.wait) && this.token.equals(another.token) && this.index.equals(another.index) && this.near.equals(another.near) && this.consistencyMode.equals((Object)another.consistencyMode) && this.isBlocking == another.isBlocking && this.hasToken == another.hasToken;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.wait.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.index.hashCode();
        h = h * 17 + this.near.hashCode();
        h = h * 17 + this.consistencyMode.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.isBlocking);
        h = h * 17 + Booleans.hashCode((boolean)this.hasToken);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueryOptions").omitNullValues().add("wait", this.wait.orNull()).add("token", this.token.orNull()).add("index", this.index.orNull()).add("near", this.near.orNull()).add("consistencyMode", (Object)this.consistencyMode).add("isBlocking", this.isBlocking).add("hasToken", this.hasToken).toString();
    }

    private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableQueryOptions copyOf(QueryOptions instance) {
        if (instance instanceof ImmutableQueryOptions) {
            return (ImmutableQueryOptions)instance;
        }
        return ImmutableQueryOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> wait = Optional.absent();
        private Optional<String> token = Optional.absent();
        private Optional<BigInteger> index = Optional.absent();
        private Optional<String> near = Optional.absent();
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        public final Builder from(QueryOptions instance) {
            Optional<String> nearOptional;
            Optional<BigInteger> indexOptional;
            Optional<String> tokenOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> waitOptional = instance.getWait();
            if (waitOptional.isPresent()) {
                this.wait(waitOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            if ((indexOptional = instance.getIndex()).isPresent()) {
                this.index(indexOptional);
            }
            if ((nearOptional = instance.getNear()).isPresent()) {
                this.near(nearOptional);
            }
            this.consistencyMode(instance.getConsistencyMode());
            return this;
        }

        public final Builder wait(String wait) {
            this.wait = Optional.of((Object)wait);
            return this;
        }

        public final Builder wait(Optional<String> wait) {
            this.wait = (Optional)Preconditions.checkNotNull(wait, (Object)"wait");
            return this;
        }

        public final Builder token(String token) {
            this.token = Optional.of((Object)token);
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = (Optional)Preconditions.checkNotNull(token, (Object)"token");
            return this;
        }

        public final Builder index(BigInteger index) {
            this.index = Optional.of((Object)index);
            return this;
        }

        public final Builder index(Optional<BigInteger> index) {
            this.index = (Optional)Preconditions.checkNotNull(index, (Object)"index");
            return this;
        }

        public final Builder near(String near) {
            this.near = Optional.of((Object)near);
            return this;
        }

        public final Builder near(Optional<String> near) {
            this.near = (Optional)Preconditions.checkNotNull(near, (Object)"near");
            return this;
        }

        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)consistencyMode), (Object)"consistencyMode"));
            return this;
        }

        public ImmutableQueryOptions build() {
            return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
        }
    }

    private final class InitShim {
        private ConsistencyMode consistencyMode;
        private byte consistencyModeStage;
        private boolean isBlocking;
        private byte isBlockingStage;
        private boolean hasToken;
        private byte hasTokenStage;

        private InitShim() {
        }

        ConsistencyMode getConsistencyMode() {
            if (this.consistencyModeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consistencyModeStage == 0) {
                this.consistencyModeStage = (byte)-1;
                this.consistencyMode = (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)ImmutableQueryOptions.super.getConsistencyMode()), (Object)"consistencyMode"));
                this.consistencyModeStage = 1;
            }
            return this.consistencyMode;
        }

        ConsistencyMode consistencyMode(ConsistencyMode value) {
            this.consistencyMode = value;
            this.consistencyModeStage = 1;
            return value;
        }

        boolean isBlocking() {
            if (this.isBlockingStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBlockingStage == 0) {
                this.isBlockingStage = (byte)-1;
                this.isBlocking = ImmutableQueryOptions.super.isBlocking();
                this.isBlockingStage = 1;
            }
            return this.isBlocking;
        }

        boolean hasToken() {
            if (this.hasTokenStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTokenStage == 0) {
                this.hasTokenStage = (byte)-1;
                this.hasToken = ImmutableQueryOptions.super.hasToken();
                this.hasTokenStage = 1;
            }
            return this.hasToken;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.consistencyModeStage == -1) {
                attributes.add("consistencyMode");
            }
            if (this.isBlockingStage == -1) {
                attributes.add("isBlocking");
            }
            if (this.hasTokenStage == -1) {
                attributes.add("hasToken");
            }
            return "Cannot build QueryOptions, attribute initializers form cycle" + attributes;
        }
    }
}

