/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.base.Function;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.option.CatalogOptions;
import java.math.BigInteger;
import java.util.List;

public class HealthCheckCache
extends ConsulCache<String, HealthCheck> {
    private HealthCheckCache(Function<HealthCheck, String> keyConversion, ConsulCache.CallbackConsumer<HealthCheck> callbackConsumer) {
        super(keyConversion, callbackConsumer);
    }

    public static HealthCheckCache newCache(final HealthClient healthClient, final State state, final CatalogOptions catalogOptions, final int watchSeconds) {
        Function<HealthCheck, String> keyExtractor = new Function<HealthCheck, String>(){

            public String apply(HealthCheck input) {
                return input.getCheckId();
            }
        };
        ConsulCache.CallbackConsumer<HealthCheck> callbackConsumer = new ConsulCache.CallbackConsumer<HealthCheck>(){

            @Override
            public void consume(BigInteger index, ConsulResponseCallback<List<HealthCheck>> callback) {
                healthClient.getChecksByState(state, catalogOptions, ConsulCache.watchParams(index, watchSeconds), callback);
            }
        };
        return new HealthCheckCache(keyExtractor, callbackConsumer);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State state) {
        return HealthCheckCache.newCache(healthClient, state, CatalogOptions.BLANK, 10);
    }
}

