/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.fasterxml.jackson.databind.jsontype.impl;

import com.orbitz.fasterxml.jackson.annotation.JsonTypeInfo;
import com.orbitz.fasterxml.jackson.core.JsonGenerator;
import com.orbitz.fasterxml.jackson.databind.BeanProperty;
import com.orbitz.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.orbitz.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsWrapperTypeSerializer
extends TypeSerializerBase {
    public AsWrapperTypeSerializer(TypeIdResolver idRes, BeanProperty property) {
        super(idRes, property);
    }

    @Override
    public AsWrapperTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsWrapperTypeSerializer(this._idResolver, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    @Override
    public void writeTypePrefixForObject(Object value, JsonGenerator g) throws IOException {
        String typeId = this.idFromValue(value);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartObject();
        } else {
            g.writeStartObject();
            g.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForObject(Object value, JsonGenerator g, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value, type);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartObject();
        } else {
            g.writeStartObject();
            g.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value, JsonGenerator g) throws IOException {
        String typeId = this.idFromValue(value);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartArray();
        } else {
            g.writeStartObject();
            g.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value, JsonGenerator g, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value, type);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartArray();
        } else {
            g.writeStartObject();
            g.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value, JsonGenerator g) throws IOException {
        String typeId = this.idFromValue(value);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
        } else {
            g.writeStartObject();
            g.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value, JsonGenerator g, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value, type);
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
        } else {
            g.writeStartObject();
            g.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object value, JsonGenerator g) throws IOException {
        g.writeEndObject();
        if (!g.canWriteTypeId()) {
            g.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForArray(Object value, JsonGenerator g) throws IOException {
        g.writeEndArray();
        if (!g.canWriteTypeId()) {
            g.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForScalar(Object value, JsonGenerator g) throws IOException {
        if (!g.canWriteTypeId()) {
            g.writeEndObject();
        }
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value, JsonGenerator g, String typeId) throws IOException {
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartObject();
        } else {
            g.writeStartObject();
            g.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypePrefixForArray(Object value, JsonGenerator g, String typeId) throws IOException {
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
            g.writeStartArray();
        } else {
            g.writeStartObject();
            g.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object value, JsonGenerator g, String typeId) throws IOException {
        if (g.canWriteTypeId()) {
            if (typeId != null) {
                g.writeTypeId(typeId);
            }
        } else {
            g.writeStartObject();
            g.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value, JsonGenerator g, String typeId) throws IOException {
        if (!g.canWriteTypeId()) {
            this.writeTypeSuffixForObject(value, g);
        }
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object value, JsonGenerator g, String typeId) throws IOException {
        if (!g.canWriteTypeId()) {
            this.writeTypeSuffixForArray(value, g);
        }
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object value, JsonGenerator g, String typeId) throws IOException {
        if (!g.canWriteTypeId()) {
            this.writeTypeSuffixForScalar(value, g);
        }
    }

    protected String _validTypeId(String typeId) {
        return typeId == null ? "" : typeId;
    }
}

