/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.query.DnsQuery;
import com.orbitz.consul.model.query.ServiceQuery;
import com.orbitz.consul.model.query.StoredQuery;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableStoredQuery
extends StoredQuery {
    private final String id;
    private final String name;
    private final String session;
    private final String token;
    private final ServiceQuery service;
    private final DnsQuery dns;

    private ImmutableStoredQuery(String id, String name, String session, String token, ServiceQuery service, DnsQuery dns) {
        this.id = id;
        this.name = name;
        this.session = session;
        this.token = token;
        this.service = service;
        this.dns = dns;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Session")
    public String getSession() {
        return this.session;
    }

    @Override
    @JsonProperty(value="Token")
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="Service")
    public ServiceQuery getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="DNS")
    public DnsQuery getDns() {
        return this.dns;
    }

    public final ImmutableStoredQuery withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableStoredQuery((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.name, this.session, this.token, this.service, this.dns);
    }

    public final ImmutableStoredQuery withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.session, this.token, this.service, this.dns);
    }

    public final ImmutableStoredQuery withSession(String value) {
        if (this.session.equals(value)) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, this.name, (String)Preconditions.checkNotNull((Object)value, (Object)"session"), this.token, this.service, this.dns);
    }

    public final ImmutableStoredQuery withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, this.name, this.session, (String)Preconditions.checkNotNull((Object)value, (Object)"token"), this.service, this.dns);
    }

    public final ImmutableStoredQuery withService(ServiceQuery value) {
        if (this.service == value) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, this.name, this.session, this.token, (ServiceQuery)Preconditions.checkNotNull((Object)value, (Object)"service"), this.dns);
    }

    public final ImmutableStoredQuery withDns(DnsQuery value) {
        if (this.dns == value) {
            return this;
        }
        return new ImmutableStoredQuery(this.id, this.name, this.session, this.token, this.service, (DnsQuery)Preconditions.checkNotNull((Object)value, (Object)"dns"));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredQuery && this.equalTo((ImmutableStoredQuery)another);
    }

    private boolean equalTo(ImmutableStoredQuery another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.session.equals(another.session) && this.token.equals(another.token) && this.service.equals(another.service) && this.dns.equals(another.dns);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.session.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.dns.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredQuery").add("id", (Object)this.id).add("name", (Object)this.name).add("session", (Object)this.session).add("token", (Object)this.token).add("service", (Object)this.service).add("dns", (Object)this.dns).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableStoredQuery fromJson(Json json) {
        Builder builder = ImmutableStoredQuery.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.dns != null) {
            builder.dns(json.dns);
        }
        return builder.build();
    }

    public static ImmutableStoredQuery copyOf(StoredQuery instance) {
        if (instance instanceof ImmutableStoredQuery) {
            return (ImmutableStoredQuery)instance;
        }
        return ImmutableStoredQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_SESSION = 4L;
        private static final long INIT_BIT_TOKEN = 8L;
        private static final long INIT_BIT_SERVICE = 16L;
        private static final long INIT_BIT_DNS = 32L;
        private long initBits = 63L;
        private String id;
        private String name;
        private String session;
        private String token;
        private ServiceQuery service;
        private DnsQuery dns;

        private Builder() {
        }

        public final Builder from(StoredQuery instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.session(instance.getSession());
            this.token(instance.getToken());
            this.service(instance.getService());
            this.dns(instance.getDns());
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder session(String session) {
            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"session");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder service(ServiceQuery service) {
            this.service = (ServiceQuery)Preconditions.checkNotNull((Object)service, (Object)"service");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder dns(DnsQuery dns) {
            this.dns = (DnsQuery)Preconditions.checkNotNull((Object)dns, (Object)"dns");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableStoredQuery build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredQuery(this.id, this.name, this.session, this.token, this.service, this.dns);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("session");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("service");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("dns");
            }
            return "Cannot build StoredQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends StoredQuery {
        String id;
        String name;
        String session;
        String token;
        ServiceQuery service;
        DnsQuery dns;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Session")
        public void setSession(String session) {
            this.session = session;
        }

        @JsonProperty(value="Token")
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(value="Service")
        public void setService(ServiceQuery service) {
            this.service = service;
        }

        @JsonProperty(value="DNS")
        public void setDns(DnsQuery dns) {
            this.dns = dns;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSession() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceQuery getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DnsQuery getDns() {
            throw new UnsupportedOperationException();
        }
    }
}

