/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLongs;
import com.orbitz.apache.commons.lang3.StringUtils;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.option.ImmutablePutOptions;
import com.orbitz.consul.option.PutOptions;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import com.orbitz.consul.util.Strings;
import com.orbitz.okhttp3.MediaType;
import com.orbitz.okhttp3.RequestBody;
import com.orbitz.retrofit.Call;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.http.Body;
import com.orbitz.retrofit.http.DELETE;
import com.orbitz.retrofit.http.GET;
import com.orbitz.retrofit.http.PUT;
import com.orbitz.retrofit.http.Path;
import com.orbitz.retrofit.http.QueryMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeyValueClient {
    private final Api api;

    KeyValueClient(Retrofit retrofit) {
        this.api = retrofit.create(Api.class);
    }

    public Optional<Value> getValue(String key) {
        return this.getValue(key, QueryOptions.BLANK);
    }

    public Optional<Value> getValue(String key, QueryOptions queryOptions) {
        try {
            return this.getSingleValue(Http.extract(this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery())));
        }
        catch (ConsulException ignored) {
            if (ignored.getCode() != 404) {
                throw ignored;
            }
            return Optional.absent();
        }
    }

    public void getValue(String key, QueryOptions queryOptions, final ConsulResponseCallback<Optional<Value>> callback) {
        ConsulResponseCallback<List<Value>> wrapper = new ConsulResponseCallback<List<Value>>(){

            @Override
            public void onComplete(ConsulResponse<List<Value>> consulResponse) {
                callback.onComplete(new ConsulResponse<Optional>(KeyValueClient.this.getSingleValue(consulResponse.getResponse()), consulResponse.getLastContact(), consulResponse.isKnownLeader(), consulResponse.getIndex()));
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
        Http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery()), wrapper);
    }

    private Optional<Value> getSingleValue(List<Value> values) {
        return values != null && values.size() != 0 ? Optional.of((Object)values.get(0)) : Optional.absent();
    }

    public List<Value> getValues(String key) {
        return this.getValues(key, QueryOptions.BLANK);
    }

    public List<Value> getValues(String key, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put("recurse", "true");
        return Http.extract(this.api.getValue(Strings.trimLeadingSlash(key), query));
    }

    public void getValues(String key, QueryOptions queryOptions, ConsulResponseCallback<List<Value>> callback) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put("recurse", "true");
        Http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), query), callback);
    }

    public Optional<String> getValueAsString(String key) {
        Iterator iterator = this.getValue(key).asSet().iterator();
        if (iterator.hasNext()) {
            Value v = (Value)iterator.next();
            return v.getValueAsString();
        }
        return Optional.absent();
    }

    public List<String> getValuesAsString(String key) {
        ArrayList<String> result = new ArrayList<String>();
        for (Value value : this.getValues(key)) {
            if (!value.getValueAsString().isPresent()) continue;
            result.add((String)value.getValueAsString().get());
        }
        return result;
    }

    public boolean putValue(String key) {
        return this.putValue(key, null, 0L, PutOptions.BLANK);
    }

    public boolean putValue(String key, String value) {
        return this.putValue(key, value, 0L, PutOptions.BLANK);
    }

    public boolean putValue(String key, String value, long flags) {
        return this.putValue(key, value, flags, PutOptions.BLANK);
    }

    public boolean putValue(String key, String value, long flags, PutOptions putOptions) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(key), (Object)"Key must be defined");
        Map<String, Object> query = putOptions.toQuery();
        if (flags != 0L) {
            query.put("flags", UnsignedLongs.toString((long)flags));
        }
        if (value == null) {
            return Http.extract(this.api.putValue(Strings.trimLeadingSlash(key), query));
        }
        return Http.extract(this.api.putValue(Strings.trimLeadingSlash(key), RequestBody.create(MediaType.parse("text/plain"), value), query));
    }

    public List<String> getKeys(String key) {
        List<Value> values = Http.extract(this.api.getValue(Strings.trimLeadingSlash(key), (Map<String, Object>)ImmutableMap.of((Object)"keys", (Object)"true")));
        return FluentIterable.from(values).transform((Function)new Function<Value, String>(){

            public String apply(Value input) {
                return (String)input.getValue().get();
            }
        }).toList();
    }

    public void deleteKey(String key) {
        Http.handle(this.api.deleteValue(Strings.trimLeadingSlash(key)));
    }

    public void deleteKeys(String key) {
        Http.handle(this.api.deleteValues(Strings.trimLeadingSlash(key), (Map<String, String>)ImmutableMap.of((Object)"recurse", (Object)"true")));
    }

    public boolean acquireLock(String key, String session) {
        return this.acquireLock(key, "", session);
    }

    public boolean acquireLock(String key, String value, String session) {
        return this.putValue(key, value, 0L, ImmutablePutOptions.builder().acquire(session).build());
    }

    public Optional<String> getSession(String key) {
        Optional<Value> value = this.getValue(key);
        return value.isPresent() ? ((Value)value.get()).getSession() : Optional.absent();
    }

    public boolean releaseLock(String key, String sessionId) {
        return this.putValue(key, "", 0L, ImmutablePutOptions.builder().release(sessionId).build());
    }

    static interface Api {
        @GET(value="kv/{key}")
        public Call<List<Value>> getValue(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="kv/{key}")
        public Call<Boolean> putValue(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="kv/{key}")
        public Call<Boolean> putValue(@Path(value="key") String var1, @Body RequestBody var2, @QueryMap Map<String, Object> var3);

        @DELETE(value="kv/{key}")
        public Call<Void> deleteValue(@Path(value="key") String var1);

        @DELETE(value="kv/{key}")
        public Call<Void> deleteValues(@Path(value="key") String var1, @QueryMap Map<String, String> var2);
    }
}

