/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.fasterxml.jackson.datatype.guava.deser;

import com.orbitz.fasterxml.jackson.core.JsonParser;
import com.orbitz.fasterxml.jackson.core.JsonProcessingException;
import com.orbitz.fasterxml.jackson.core.JsonToken;
import com.orbitz.fasterxml.jackson.databind.DeserializationContext;
import com.orbitz.fasterxml.jackson.databind.JsonDeserializer;
import com.orbitz.fasterxml.jackson.databind.KeyDeserializer;
import com.orbitz.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.orbitz.fasterxml.jackson.databind.type.MapType;
import com.orbitz.fasterxml.jackson.datatype.guava.deser.GuavaMapDeserializer;
import com.orbitz.google.common.collect.ImmutableMap;
import java.io.IOException;

abstract class GuavaImmutableMapDeserializer<T extends ImmutableMap<Object, Object>>
extends GuavaMapDeserializer<T> {
    GuavaImmutableMapDeserializer(MapType type, KeyDeserializer keyDeser, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(type, keyDeser, typeDeser, deser);
    }

    protected abstract ImmutableMap.Builder<Object, Object> createBuilder();

    @Override
    protected T _deserializeEntries(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        ImmutableMap.Builder<Object, Object> builder = this.createBuilder();
        while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
            String fieldName = p.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            JsonToken t = p.nextToken();
            if (t == JsonToken.VALUE_NULL) {
                this._handleNull(ctxt, key, this._valueDeserializer, builder);
            } else {
                Object value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
                builder.put(key, value);
            }
            p.nextToken();
        }
        ImmutableMap<Object, Object> map = builder.build();
        return (T)map;
    }

    protected void _handleNull(DeserializationContext ctxt, Object key, JsonDeserializer<?> valueDeser, ImmutableMap.Builder<Object, Object> builder) throws IOException {
        Object nvl = valueDeser.getNullValue(ctxt);
        if (nvl != null) {
            builder.put(key, nvl);
        }
    }
}

