/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.model.query.QueryResults;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.ImmutableList;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableQueryResults
extends QueryResults {
    private final String service;
    private final ImmutableList<ServiceHealth> nodes;

    private ImmutableQueryResults(String service, ImmutableList<ServiceHealth> nodes) {
        this.service = service;
        this.nodes = nodes;
    }

    @Override
    @JsonProperty(value="Service")
    public String service() {
        return this.service;
    }

    @JsonProperty(value="Nodes")
    public ImmutableList<ServiceHealth> nodes() {
        return this.nodes;
    }

    public final ImmutableQueryResults withService(String value) {
        if (this.service.equals(value)) {
            return this;
        }
        return new ImmutableQueryResults(Preconditions.checkNotNull(value, "service"), this.nodes);
    }

    public final ImmutableQueryResults withNodes(ServiceHealth ... elements) {
        ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResults(this.service, newValue);
    }

    public final ImmutableQueryResults withNodes(Iterable<? extends ServiceHealth> elements) {
        if (this.nodes == elements) {
            return this;
        }
        ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResults(this.service, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryResults && this.equalTo((ImmutableQueryResults)another);
    }

    private boolean equalTo(ImmutableQueryResults another) {
        return this.service.equals(another.service) && this.nodes.equals(another.nodes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.nodes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryResults").add("service", this.service).add("nodes", this.nodes).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableQueryResults fromJson(Json json) {
        Builder builder = ImmutableQueryResults.builder();
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.nodes != null) {
            builder.addAllNodes(json.nodes);
        }
        return builder.build();
    }

    public static ImmutableQueryResults copyOf(QueryResults instance) {
        if (instance instanceof ImmutableQueryResults) {
            return (ImmutableQueryResults)instance;
        }
        return ImmutableQueryResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE = 1L;
        private long initBits = 1L;
        private String service;
        private ImmutableList.Builder<ServiceHealth> nodesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(QueryResults instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.service(instance.service());
            this.addAllNodes(instance.nodes());
            return this;
        }

        public final Builder service(String service) {
            this.service = Preconditions.checkNotNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addNodes(ServiceHealth element) {
            this.nodesBuilder.add((Object)element);
            return this;
        }

        public final Builder addNodes(ServiceHealth ... elements) {
            this.nodesBuilder.add(elements);
            return this;
        }

        public final Builder nodes(Iterable<? extends ServiceHealth> elements) {
            this.nodesBuilder = ImmutableList.builder();
            return this.addAllNodes(elements);
        }

        public final Builder addAllNodes(Iterable<? extends ServiceHealth> elements) {
            this.nodesBuilder.addAll(elements);
            return this;
        }

        public ImmutableQueryResults build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryResults(this.service, (ImmutableList)this.nodesBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build QueryResults, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends QueryResults {
        String service;
        List<ServiceHealth> nodes = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="Nodes")
        public void setNodes(List<ServiceHealth> nodes) {
            this.nodes = nodes;
        }

        @Override
        public String service() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ServiceHealth> nodes() {
            throw new UnsupportedOperationException();
        }
    }
}

