/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import com.orbitz.consul.model.query.DnsQuery;
import com.orbitz.consul.model.query.QueryResult;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.ImmutableList;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableQueryResult
extends QueryResult {
    private final Node node;
    private final Service service;
    private final ImmutableList<HealthCheck> checks;
    private final Optional<DnsQuery> dns;
    private final Optional<String> datacenters;
    private final Optional<Integer> failovers;

    private ImmutableQueryResult(Node node, Service service, ImmutableList<HealthCheck> checks, Optional<DnsQuery> dns, Optional<String> datacenters, Optional<Integer> failovers) {
        this.node = node;
        this.service = service;
        this.checks = checks;
        this.dns = dns;
        this.datacenters = datacenters;
        this.failovers = failovers;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Service")
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="Checks")
    @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
    public ImmutableList<HealthCheck> getChecks() {
        return this.checks;
    }

    @Override
    @JsonProperty(value="DNS")
    public Optional<DnsQuery> getDns() {
        return this.dns;
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<String> datacenters() {
        return this.datacenters;
    }

    @Override
    @JsonProperty(value="Failovers")
    public Optional<Integer> failovers() {
        return this.failovers;
    }

    public final ImmutableQueryResult withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        return new ImmutableQueryResult(Preconditions.checkNotNull(value, "node"), this.service, this.checks, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withService(Service value) {
        if (this.service == value) {
            return this;
        }
        return new ImmutableQueryResult(this.node, Preconditions.checkNotNull(value, "service"), this.checks, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withChecks(HealthCheck ... elements) {
        ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResult(this.node, this.service, newValue, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withChecks(Iterable<? extends HealthCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResult(this.node, this.service, newValue, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withDns(DnsQuery value) {
        Optional<DnsQuery> newValue = Optional.of(value);
        return new ImmutableQueryResult(this.node, this.service, this.checks, newValue, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withDns(Optional<DnsQuery> optional) {
        Optional<DnsQuery> value = Preconditions.checkNotNull(optional, "dns");
        if (this.dns == value) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, value, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withDatacenters(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, newValue, this.failovers);
    }

    public final ImmutableQueryResult withDatacenters(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "datacenters");
        if (this.datacenters == value) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, value, this.failovers);
    }

    public final ImmutableQueryResult withFailovers(int value) {
        Optional<Integer> newValue = Optional.of(value);
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, newValue);
    }

    public final ImmutableQueryResult withFailovers(Optional<Integer> optional) {
        Optional<Integer> value = Preconditions.checkNotNull(optional, "failovers");
        if (this.failovers == value) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryResult && this.equalTo((ImmutableQueryResult)another);
    }

    private boolean equalTo(ImmutableQueryResult another) {
        return this.node.equals(another.node) && this.service.equals(another.service) && this.checks.equals(another.checks) && this.dns.equals(another.dns) && this.datacenters.equals(another.datacenters) && this.failovers.equals(another.failovers);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.checks.hashCode();
        h = h * 17 + this.dns.hashCode();
        h = h * 17 + this.datacenters.hashCode();
        h = h * 17 + this.failovers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryResult").add("node", this.node).add("service", this.service).add("checks", this.checks).add("dns", this.dns).add("datacenters", this.datacenters).add("failovers", this.failovers).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableQueryResult fromJson(Json json) {
        Builder builder = ImmutableQueryResult.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.dns != null) {
            builder.dns(json.dns);
        }
        if (json.datacenters != null) {
            builder.datacenters(json.datacenters);
        }
        if (json.failovers != null) {
            builder.failovers(json.failovers);
        }
        return builder.build();
    }

    public static ImmutableQueryResult copyOf(QueryResult instance) {
        if (instance instanceof ImmutableQueryResult) {
            return (ImmutableQueryResult)instance;
        }
        return ImmutableQueryResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        private Node node;
        private Service service;
        private ImmutableList.Builder<HealthCheck> checksBuilder = ImmutableList.builder();
        private Optional<DnsQuery> dns = Optional.absent();
        private Optional<String> datacenters = Optional.absent();
        private Optional<Integer> failovers = Optional.absent();

        private Builder() {
        }

        public final Builder from(QueryResult instance) {
            Optional<Integer> failoversOptional;
            Optional<String> datacentersOptional;
            Preconditions.checkNotNull(instance, "instance");
            this.node(instance.getNode());
            this.service(instance.getService());
            this.addAllChecks(instance.getChecks());
            Optional<DnsQuery> dnsOptional = instance.getDns();
            if (dnsOptional.isPresent()) {
                this.dns(dnsOptional);
            }
            if ((datacentersOptional = instance.datacenters()).isPresent()) {
                this.datacenters(datacentersOptional);
            }
            if ((failoversOptional = instance.failovers()).isPresent()) {
                this.failovers(failoversOptional);
            }
            return this;
        }

        public final Builder node(Node node) {
            this.node = Preconditions.checkNotNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder service(Service service) {
            this.service = Preconditions.checkNotNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addChecks(HealthCheck element) {
            this.checksBuilder.add((Object)element);
            return this;
        }

        public final Builder addChecks(HealthCheck ... elements) {
            this.checksBuilder.add(elements);
            return this;
        }

        public final Builder checks(Iterable<? extends HealthCheck> elements) {
            this.checksBuilder = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
            this.checksBuilder.addAll(elements);
            return this;
        }

        public final Builder dns(DnsQuery dns) {
            this.dns = Optional.of(dns);
            return this;
        }

        public final Builder dns(Optional<DnsQuery> dns) {
            this.dns = Preconditions.checkNotNull(dns, "dns");
            return this;
        }

        public final Builder datacenters(String datacenters) {
            this.datacenters = Optional.of(datacenters);
            return this;
        }

        public final Builder datacenters(Optional<String> datacenters) {
            this.datacenters = Preconditions.checkNotNull(datacenters, "datacenters");
            return this;
        }

        public final Builder failovers(int failovers) {
            this.failovers = Optional.of(failovers);
            return this;
        }

        public final Builder failovers(Optional<Integer> failovers) {
            this.failovers = Preconditions.checkNotNull(failovers, "failovers");
            return this;
        }

        public ImmutableQueryResult build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryResult(this.node, this.service, (ImmutableList)this.checksBuilder.build(), this.dns, this.datacenters, this.failovers);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build QueryResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends QueryResult {
        Node node;
        Service service;
        List<HealthCheck> checks = ImmutableList.of();
        Optional<DnsQuery> dns = Optional.absent();
        Optional<String> datacenters = Optional.absent();
        Optional<Integer> failovers = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this.node = node;
        }

        @JsonProperty(value="Service")
        public void setService(Service service) {
            this.service = service;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        public void setChecks(List<HealthCheck> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="DNS")
        public void setDns(Optional<DnsQuery> dns) {
            this.dns = dns;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<String> datacenters) {
            this.datacenters = datacenters;
        }

        @JsonProperty(value="Failovers")
        public void setFailovers(Optional<Integer> failovers) {
            this.failovers = failovers;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Service getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<HealthCheck> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DnsQuery> getDns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> datacenters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> failovers() {
            throw new UnsupportedOperationException();
        }
    }
}

