/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.orbitz.consul.model.query.Failover;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableFailover
extends Failover {
    private final Optional<Integer> nearestN;
    private final Optional<String> datacenters;

    private ImmutableFailover(Optional<Integer> nearestN, Optional<String> datacenters) {
        this.nearestN = nearestN;
        this.datacenters = datacenters;
    }

    @Override
    @JsonProperty(value="NearestN")
    public Optional<Integer> getNearestN() {
        return this.nearestN;
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<String> datacenters() {
        return this.datacenters;
    }

    public final ImmutableFailover withNearestN(int value) {
        Optional<Integer> newValue = Optional.of(value);
        return new ImmutableFailover(newValue, this.datacenters);
    }

    public final ImmutableFailover withNearestN(Optional<Integer> optional) {
        Optional<Integer> value = Preconditions.checkNotNull(optional, "nearestN");
        if (this.nearestN == value) {
            return this;
        }
        return new ImmutableFailover(value, this.datacenters);
    }

    public final ImmutableFailover withDatacenters(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutableFailover(this.nearestN, newValue);
    }

    public final ImmutableFailover withDatacenters(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "datacenters");
        if (this.datacenters == value) {
            return this;
        }
        return new ImmutableFailover(this.nearestN, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFailover && this.equalTo((ImmutableFailover)another);
    }

    private boolean equalTo(ImmutableFailover another) {
        return this.nearestN.equals(another.nearestN) && this.datacenters.equals(another.datacenters);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.nearestN.hashCode();
        h = h * 17 + this.datacenters.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Failover").add("nearestN", this.nearestN).add("datacenters", this.datacenters).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableFailover fromJson(Json json) {
        Builder builder = ImmutableFailover.builder();
        if (json.nearestN != null) {
            builder.nearestN(json.nearestN);
        }
        if (json.datacenters != null) {
            builder.datacenters(json.datacenters);
        }
        return builder.build();
    }

    public static ImmutableFailover copyOf(Failover instance) {
        if (instance instanceof ImmutableFailover) {
            return (ImmutableFailover)instance;
        }
        return ImmutableFailover.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<Integer> nearestN = Optional.absent();
        private Optional<String> datacenters = Optional.absent();

        private Builder() {
        }

        public final Builder from(Failover instance) {
            Optional<String> datacentersOptional;
            Preconditions.checkNotNull(instance, "instance");
            Optional<Integer> nearestNOptional = instance.getNearestN();
            if (nearestNOptional.isPresent()) {
                this.nearestN(nearestNOptional);
            }
            if ((datacentersOptional = instance.datacenters()).isPresent()) {
                this.datacenters(datacentersOptional);
            }
            return this;
        }

        public final Builder nearestN(int nearestN) {
            this.nearestN = Optional.of(nearestN);
            return this;
        }

        public final Builder nearestN(Optional<Integer> nearestN) {
            this.nearestN = Preconditions.checkNotNull(nearestN, "nearestN");
            return this;
        }

        public final Builder datacenters(String datacenters) {
            this.datacenters = Optional.of(datacenters);
            return this;
        }

        public final Builder datacenters(Optional<String> datacenters) {
            this.datacenters = Preconditions.checkNotNull(datacenters, "datacenters");
            return this;
        }

        public ImmutableFailover build() throws IllegalStateException {
            return new ImmutableFailover(this.nearestN, this.datacenters);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Failover {
        Optional<Integer> nearestN = Optional.absent();
        Optional<String> datacenters = Optional.absent();

        Json() {
        }

        @JsonProperty(value="NearestN")
        public void setNearestN(Optional<Integer> nearestN) {
            this.nearestN = nearestN;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<String> datacenters) {
            this.datacenters = datacenters;
        }

        @Override
        public Optional<Integer> getNearestN() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> datacenters() {
            throw new UnsupportedOperationException();
        }
    }
}

