/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.kv;

import com.orbitz.consul.model.kv.ImmutableValue;
import com.orbitz.consul.util.UnsignedLongDeserializer;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnore;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.io.BaseEncoding;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableValue.class)
@JsonSerialize(as=ImmutableValue.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
public abstract class Value {
    @JsonProperty(value="CreateIndex")
    public abstract long getCreateIndex();

    @JsonProperty(value="ModifyIndex")
    public abstract long getModifyIndex();

    @JsonProperty(value="LockIndex")
    public abstract long getLockIndex();

    @JsonProperty(value="Key")
    public abstract String getKey();

    @JsonProperty(value="Flags")
    @JsonDeserialize(using=UnsignedLongDeserializer.class)
    public abstract long getFlags();

    @JsonProperty(value="Value")
    public abstract Optional<String> getValue();

    @JsonProperty(value="Session")
    public abstract Optional<String> getSession();

    @JsonIgnore
    @Value.Lazy
    public Optional<String> getValueAsString() {
        if (this.getValue().isPresent()) {
            return Optional.of(new String(BaseEncoding.base64().decode(this.getValue().get())).replaceAll("^\"|\"$", ""));
        }
        return Optional.absent();
    }
}

