/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.orbitz.consul.model.agent.Config;
import com.orbitz.consul.model.agent.Ports;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.ImmutableList;
import com.orbitz.google.common.collect.Lists;
import com.orbitz.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableConfig
extends Config {
    private final boolean bootstrap;
    private final boolean server;
    private final String datacenter;
    private final String dataDir;
    private final String dnsRecursor;
    private final String domain;
    private final String logLevel;
    private final String nodeName;
    private final String clientAddr;
    private final String bindAddr;
    private final String advertiseAddr;
    private final Ports ports;
    private final boolean leaveOnTerm;
    private final boolean skipLeaveOnInt;
    private final String statsiteAddr;
    private final int protocol;
    private final boolean enableDebug;
    private final boolean verifyIncoming;
    private final boolean verifyOutgoing;
    private final String caFile;
    private final String certFile;
    private final String keyFile;
    private final ImmutableList<String> startJoin;
    private final String uiDir;
    private final String pidFile;
    private final boolean enableSyslog;
    private final boolean rejoinAfterLeave;

    private ImmutableConfig(boolean bootstrap, boolean server, String datacenter, String dataDir, String dnsRecursor, String domain, String logLevel, String nodeName, String clientAddr, String bindAddr, String advertiseAddr, Ports ports, boolean leaveOnTerm, boolean skipLeaveOnInt, String statsiteAddr, int protocol, boolean enableDebug, boolean verifyIncoming, boolean verifyOutgoing, String caFile, String certFile, String keyFile, ImmutableList<String> startJoin, String uiDir, String pidFile, boolean enableSyslog, boolean rejoinAfterLeave) {
        this.bootstrap = bootstrap;
        this.server = server;
        this.datacenter = datacenter;
        this.dataDir = dataDir;
        this.dnsRecursor = dnsRecursor;
        this.domain = domain;
        this.logLevel = logLevel;
        this.nodeName = nodeName;
        this.clientAddr = clientAddr;
        this.bindAddr = bindAddr;
        this.advertiseAddr = advertiseAddr;
        this.ports = ports;
        this.leaveOnTerm = leaveOnTerm;
        this.skipLeaveOnInt = skipLeaveOnInt;
        this.statsiteAddr = statsiteAddr;
        this.protocol = protocol;
        this.enableDebug = enableDebug;
        this.verifyIncoming = verifyIncoming;
        this.verifyOutgoing = verifyOutgoing;
        this.caFile = caFile;
        this.certFile = certFile;
        this.keyFile = keyFile;
        this.startJoin = startJoin;
        this.uiDir = uiDir;
        this.pidFile = pidFile;
        this.enableSyslog = enableSyslog;
        this.rejoinAfterLeave = rejoinAfterLeave;
    }

    @Override
    @JsonProperty(value="Bootstrap")
    public boolean getBootstrap() {
        return this.bootstrap;
    }

    @Override
    @JsonProperty(value="Server")
    public boolean getServer() {
        return this.server;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    @JsonProperty(value="DataDir")
    public String getDataDir() {
        return this.dataDir;
    }

    @Override
    @JsonProperty(value="DNSRecursor")
    public String dnsRecursor() {
        return this.dnsRecursor;
    }

    @Override
    @JsonProperty(value="Domain")
    public String getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty(value="LogLevel")
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    @JsonProperty(value="NodeName")
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    @JsonProperty(value="ClientAddr")
    public String getClientAddr() {
        return this.clientAddr;
    }

    @Override
    @JsonProperty(value="BindAddr")
    public String getBindAddr() {
        return this.bindAddr;
    }

    @Override
    @JsonProperty(value="AdvertiseAddr")
    public String getAdvertiseAddr() {
        return this.advertiseAddr;
    }

    @Override
    @JsonProperty(value="Ports")
    public Ports getPorts() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="LeaveOnTerm")
    public boolean getLeaveOnTerm() {
        return this.leaveOnTerm;
    }

    @Override
    @JsonProperty(value="SkipLeaveOnInt")
    public boolean getSkipLeaveOnInt() {
        return this.skipLeaveOnInt;
    }

    @Override
    @JsonProperty(value="StatsiteAddr")
    public String getStatsiteAddr() {
        return this.statsiteAddr;
    }

    @Override
    @JsonProperty(value="Protocol")
    public int getProtocol() {
        return this.protocol;
    }

    @Override
    @JsonProperty(value="EnableDebug")
    public boolean getEnableDebug() {
        return this.enableDebug;
    }

    @Override
    @JsonProperty(value="VerifyIncoming")
    public boolean getVerifyIncoming() {
        return this.verifyIncoming;
    }

    @Override
    @JsonProperty(value="VerifyOutgoing")
    public boolean getVerifyOutgoing() {
        return this.verifyOutgoing;
    }

    @Override
    @JsonProperty(value="CAFile")
    public String getCaFile() {
        return this.caFile;
    }

    @Override
    @JsonProperty(value="CertFile")
    public String getCertFile() {
        return this.certFile;
    }

    @Override
    @JsonProperty(value="KeyFile")
    public String getKeyFile() {
        return this.keyFile;
    }

    @JsonProperty(value="StartJoin")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getStartJoin() {
        return this.startJoin;
    }

    @Override
    @JsonProperty(value="UiDir")
    public String getUiDir() {
        return this.uiDir;
    }

    @Override
    @JsonProperty(value="PidFile")
    public String getPidFile() {
        return this.pidFile;
    }

    @Override
    @JsonProperty(value="EnableSyslog")
    public boolean getEnableSyslog() {
        return this.enableSyslog;
    }

    @Override
    @JsonProperty(value="RejoinAfterLeave")
    public boolean getRejoinAfterLeave() {
        return this.rejoinAfterLeave;
    }

    public final ImmutableConfig withBootstrap(boolean value) {
        if (this.bootstrap == value) {
            return this;
        }
        return new ImmutableConfig(value, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withServer(boolean value) {
        if (this.server == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, value, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withDatacenter(String value) {
        if (this.datacenter.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, Preconditions.checkNotNull(value, "datacenter"), this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withDataDir(String value) {
        if (this.dataDir.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, Preconditions.checkNotNull(value, "dataDir"), this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withDnsRecursor(String value) {
        if (this.dnsRecursor.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, Preconditions.checkNotNull(value, "dnsRecursor"), this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withDomain(String value) {
        if (this.domain.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, Preconditions.checkNotNull(value, "domain"), this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withLogLevel(String value) {
        if (this.logLevel.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, Preconditions.checkNotNull(value, "logLevel"), this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withNodeName(String value) {
        if (this.nodeName.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, Preconditions.checkNotNull(value, "nodeName"), this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withClientAddr(String value) {
        if (this.clientAddr.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, Preconditions.checkNotNull(value, "clientAddr"), this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withBindAddr(String value) {
        if (this.bindAddr.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, Preconditions.checkNotNull(value, "bindAddr"), this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withAdvertiseAddr(String value) {
        if (this.advertiseAddr.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, Preconditions.checkNotNull(value, "advertiseAddr"), this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withPorts(Ports value) {
        if (this.ports == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, Preconditions.checkNotNull(value, "ports"), this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withLeaveOnTerm(boolean value) {
        if (this.leaveOnTerm == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, value, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withSkipLeaveOnInt(boolean value) {
        if (this.skipLeaveOnInt == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, value, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withStatsiteAddr(String value) {
        if (this.statsiteAddr.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, Preconditions.checkNotNull(value, "statsiteAddr"), this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withProtocol(int value) {
        if (this.protocol == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, value, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withEnableDebug(boolean value) {
        if (this.enableDebug == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, value, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withVerifyIncoming(boolean value) {
        if (this.verifyIncoming == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, value, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withVerifyOutgoing(boolean value) {
        if (this.verifyOutgoing == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, value, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withCaFile(String value) {
        if (this.caFile.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, Preconditions.checkNotNull(value, "caFile"), this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withCertFile(String value) {
        if (this.certFile.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, Preconditions.checkNotNull(value, "certFile"), this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withKeyFile(String value) {
        if (this.keyFile.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, Preconditions.checkNotNull(value, "keyFile"), this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withStartJoin(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, newValue, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withStartJoin(Iterable<String> elements) {
        if (this.startJoin == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, newValue, this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withUiDir(String value) {
        if (this.uiDir.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, Preconditions.checkNotNull(value, "uiDir"), this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withPidFile(String value) {
        if (this.pidFile.equals(value)) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, Preconditions.checkNotNull(value, "pidFile"), this.enableSyslog, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withEnableSyslog(boolean value) {
        if (this.enableSyslog == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, value, this.rejoinAfterLeave);
    }

    public final ImmutableConfig withRejoinAfterLeave(boolean value) {
        if (this.rejoinAfterLeave == value) {
            return this;
        }
        return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, this.startJoin, this.uiDir, this.pidFile, this.enableSyslog, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfig && this.equalTo((ImmutableConfig)another);
    }

    private boolean equalTo(ImmutableConfig another) {
        return this.bootstrap == another.bootstrap && this.server == another.server && this.datacenter.equals(another.datacenter) && this.dataDir.equals(another.dataDir) && this.dnsRecursor.equals(another.dnsRecursor) && this.domain.equals(another.domain) && this.logLevel.equals(another.logLevel) && this.nodeName.equals(another.nodeName) && this.clientAddr.equals(another.clientAddr) && this.bindAddr.equals(another.bindAddr) && this.advertiseAddr.equals(another.advertiseAddr) && this.ports.equals(another.ports) && this.leaveOnTerm == another.leaveOnTerm && this.skipLeaveOnInt == another.skipLeaveOnInt && this.statsiteAddr.equals(another.statsiteAddr) && this.protocol == another.protocol && this.enableDebug == another.enableDebug && this.verifyIncoming == another.verifyIncoming && this.verifyOutgoing == another.verifyOutgoing && this.caFile.equals(another.caFile) && this.certFile.equals(another.certFile) && this.keyFile.equals(another.keyFile) && this.startJoin.equals(another.startJoin) && this.uiDir.equals(another.uiDir) && this.pidFile.equals(another.pidFile) && this.enableSyslog == another.enableSyslog && this.rejoinAfterLeave == another.rejoinAfterLeave;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.bootstrap);
        h = h * 17 + Booleans.hashCode(this.server);
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.dataDir.hashCode();
        h = h * 17 + this.dnsRecursor.hashCode();
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + this.logLevel.hashCode();
        h = h * 17 + this.nodeName.hashCode();
        h = h * 17 + this.clientAddr.hashCode();
        h = h * 17 + this.bindAddr.hashCode();
        h = h * 17 + this.advertiseAddr.hashCode();
        h = h * 17 + this.ports.hashCode();
        h = h * 17 + Booleans.hashCode(this.leaveOnTerm);
        h = h * 17 + Booleans.hashCode(this.skipLeaveOnInt);
        h = h * 17 + this.statsiteAddr.hashCode();
        h = h * 17 + this.protocol;
        h = h * 17 + Booleans.hashCode(this.enableDebug);
        h = h * 17 + Booleans.hashCode(this.verifyIncoming);
        h = h * 17 + Booleans.hashCode(this.verifyOutgoing);
        h = h * 17 + this.caFile.hashCode();
        h = h * 17 + this.certFile.hashCode();
        h = h * 17 + this.keyFile.hashCode();
        h = h * 17 + this.startJoin.hashCode();
        h = h * 17 + this.uiDir.hashCode();
        h = h * 17 + this.pidFile.hashCode();
        h = h * 17 + Booleans.hashCode(this.enableSyslog);
        h = h * 17 + Booleans.hashCode(this.rejoinAfterLeave);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Config").add("bootstrap", this.bootstrap).add("server", this.server).add("datacenter", this.datacenter).add("dataDir", this.dataDir).add("dnsRecursor", this.dnsRecursor).add("domain", this.domain).add("logLevel", this.logLevel).add("nodeName", this.nodeName).add("clientAddr", this.clientAddr).add("bindAddr", this.bindAddr).add("advertiseAddr", this.advertiseAddr).add("ports", this.ports).add("leaveOnTerm", this.leaveOnTerm).add("skipLeaveOnInt", this.skipLeaveOnInt).add("statsiteAddr", this.statsiteAddr).add("protocol", this.protocol).add("enableDebug", this.enableDebug).add("verifyIncoming", this.verifyIncoming).add("verifyOutgoing", this.verifyOutgoing).add("caFile", this.caFile).add("certFile", this.certFile).add("keyFile", this.keyFile).add("startJoin", this.startJoin).add("uiDir", this.uiDir).add("pidFile", this.pidFile).add("enableSyslog", this.enableSyslog).add("rejoinAfterLeave", this.rejoinAfterLeave).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableConfig fromJson(Json json) {
        Builder builder = ImmutableConfig.builder();
        if (json.bootstrap != null) {
            builder.bootstrap(json.bootstrap);
        }
        if (json.server != null) {
            builder.server(json.server);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.dataDir != null) {
            builder.dataDir(json.dataDir);
        }
        if (json.dnsRecursor != null) {
            builder.dnsRecursor(json.dnsRecursor);
        }
        if (json.domain != null) {
            builder.domain(json.domain);
        }
        if (json.logLevel != null) {
            builder.logLevel(json.logLevel);
        }
        if (json.nodeName != null) {
            builder.nodeName(json.nodeName);
        }
        if (json.clientAddr != null) {
            builder.clientAddr(json.clientAddr);
        }
        if (json.bindAddr != null) {
            builder.bindAddr(json.bindAddr);
        }
        if (json.advertiseAddr != null) {
            builder.advertiseAddr(json.advertiseAddr);
        }
        if (json.ports != null) {
            builder.ports(json.ports);
        }
        if (json.leaveOnTerm != null) {
            builder.leaveOnTerm(json.leaveOnTerm);
        }
        if (json.skipLeaveOnInt != null) {
            builder.skipLeaveOnInt(json.skipLeaveOnInt);
        }
        if (json.statsiteAddr != null) {
            builder.statsiteAddr(json.statsiteAddr);
        }
        if (json.protocol != null) {
            builder.protocol(json.protocol);
        }
        if (json.enableDebug != null) {
            builder.enableDebug(json.enableDebug);
        }
        if (json.verifyIncoming != null) {
            builder.verifyIncoming(json.verifyIncoming);
        }
        if (json.verifyOutgoing != null) {
            builder.verifyOutgoing(json.verifyOutgoing);
        }
        if (json.caFile != null) {
            builder.caFile(json.caFile);
        }
        if (json.certFile != null) {
            builder.certFile(json.certFile);
        }
        if (json.keyFile != null) {
            builder.keyFile(json.keyFile);
        }
        if (json.startJoin != null) {
            builder.addAllStartJoin(json.startJoin);
        }
        if (json.uiDir != null) {
            builder.uiDir(json.uiDir);
        }
        if (json.pidFile != null) {
            builder.pidFile(json.pidFile);
        }
        if (json.enableSyslog != null) {
            builder.enableSyslog(json.enableSyslog);
        }
        if (json.rejoinAfterLeave != null) {
            builder.rejoinAfterLeave(json.rejoinAfterLeave);
        }
        return builder.build();
    }

    public static ImmutableConfig copyOf(Config instance) {
        if (instance instanceof ImmutableConfig) {
            return (ImmutableConfig)instance;
        }
        return ImmutableConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOOTSTRAP = 1L;
        private static final long INIT_BIT_SERVER = 2L;
        private static final long INIT_BIT_DATACENTER = 4L;
        private static final long INIT_BIT_DATA_DIR = 8L;
        private static final long INIT_BIT_DNS_RECURSOR = 16L;
        private static final long INIT_BIT_DOMAIN = 32L;
        private static final long INIT_BIT_LOG_LEVEL = 64L;
        private static final long INIT_BIT_NODE_NAME = 128L;
        private static final long INIT_BIT_CLIENT_ADDR = 256L;
        private static final long INIT_BIT_BIND_ADDR = 512L;
        private static final long INIT_BIT_ADVERTISE_ADDR = 1024L;
        private static final long INIT_BIT_PORTS = 2048L;
        private static final long INIT_BIT_LEAVE_ON_TERM = 4096L;
        private static final long INIT_BIT_SKIP_LEAVE_ON_INT = 8192L;
        private static final long INIT_BIT_STATSITE_ADDR = 16384L;
        private static final long INIT_BIT_PROTOCOL = 32768L;
        private static final long INIT_BIT_ENABLE_DEBUG = 65536L;
        private static final long INIT_BIT_VERIFY_INCOMING = 131072L;
        private static final long INIT_BIT_VERIFY_OUTGOING = 262144L;
        private static final long INIT_BIT_CA_FILE = 524288L;
        private static final long INIT_BIT_CERT_FILE = 0x100000L;
        private static final long INIT_BIT_KEY_FILE = 0x200000L;
        private static final long INIT_BIT_UI_DIR = 0x400000L;
        private static final long INIT_BIT_PID_FILE = 0x800000L;
        private static final long INIT_BIT_ENABLE_SYSLOG = 0x1000000L;
        private static final long INIT_BIT_REJOIN_AFTER_LEAVE = 0x2000000L;
        private long initBits = 0x3FFFFFFL;
        private boolean bootstrap;
        private boolean server;
        private String datacenter;
        private String dataDir;
        private String dnsRecursor;
        private String domain;
        private String logLevel;
        private String nodeName;
        private String clientAddr;
        private String bindAddr;
        private String advertiseAddr;
        private Ports ports;
        private boolean leaveOnTerm;
        private boolean skipLeaveOnInt;
        private String statsiteAddr;
        private int protocol;
        private boolean enableDebug;
        private boolean verifyIncoming;
        private boolean verifyOutgoing;
        private String caFile;
        private String certFile;
        private String keyFile;
        private ImmutableList.Builder<String> startJoinBuilder = ImmutableList.builder();
        private String uiDir;
        private String pidFile;
        private boolean enableSyslog;
        private boolean rejoinAfterLeave;

        private Builder() {
        }

        public final Builder from(Config instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.bootstrap(instance.getBootstrap());
            this.server(instance.getServer());
            this.datacenter(instance.getDatacenter());
            this.dataDir(instance.getDataDir());
            this.dnsRecursor(instance.dnsRecursor());
            this.domain(instance.getDomain());
            this.logLevel(instance.getLogLevel());
            this.nodeName(instance.getNodeName());
            this.clientAddr(instance.getClientAddr());
            this.bindAddr(instance.getBindAddr());
            this.advertiseAddr(instance.getAdvertiseAddr());
            this.ports(instance.getPorts());
            this.leaveOnTerm(instance.getLeaveOnTerm());
            this.skipLeaveOnInt(instance.getSkipLeaveOnInt());
            this.statsiteAddr(instance.getStatsiteAddr());
            this.protocol(instance.getProtocol());
            this.enableDebug(instance.getEnableDebug());
            this.verifyIncoming(instance.getVerifyIncoming());
            this.verifyOutgoing(instance.getVerifyOutgoing());
            this.caFile(instance.getCaFile());
            this.certFile(instance.getCertFile());
            this.keyFile(instance.getKeyFile());
            this.addAllStartJoin(instance.getStartJoin());
            this.uiDir(instance.getUiDir());
            this.pidFile(instance.getPidFile());
            this.enableSyslog(instance.getEnableSyslog());
            this.rejoinAfterLeave(instance.getRejoinAfterLeave());
            return this;
        }

        public final Builder bootstrap(boolean bootstrap) {
            this.bootstrap = bootstrap;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder server(boolean server) {
            this.server = server;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder dataDir(String dataDir) {
            this.dataDir = Preconditions.checkNotNull(dataDir, "dataDir");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder dnsRecursor(String dnsRecursor) {
            this.dnsRecursor = Preconditions.checkNotNull(dnsRecursor, "dnsRecursor");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Preconditions.checkNotNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder logLevel(String logLevel) {
            this.logLevel = Preconditions.checkNotNull(logLevel, "logLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder nodeName(String nodeName) {
            this.nodeName = Preconditions.checkNotNull(nodeName, "nodeName");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder clientAddr(String clientAddr) {
            this.clientAddr = Preconditions.checkNotNull(clientAddr, "clientAddr");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder bindAddr(String bindAddr) {
            this.bindAddr = Preconditions.checkNotNull(bindAddr, "bindAddr");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder advertiseAddr(String advertiseAddr) {
            this.advertiseAddr = Preconditions.checkNotNull(advertiseAddr, "advertiseAddr");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder ports(Ports ports) {
            this.ports = Preconditions.checkNotNull(ports, "ports");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder leaveOnTerm(boolean leaveOnTerm) {
            this.leaveOnTerm = leaveOnTerm;
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder skipLeaveOnInt(boolean skipLeaveOnInt) {
            this.skipLeaveOnInt = skipLeaveOnInt;
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder statsiteAddr(String statsiteAddr) {
            this.statsiteAddr = Preconditions.checkNotNull(statsiteAddr, "statsiteAddr");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        public final Builder protocol(int protocol) {
            this.protocol = protocol;
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public final Builder enableDebug(boolean enableDebug) {
            this.enableDebug = enableDebug;
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        public final Builder verifyIncoming(boolean verifyIncoming) {
            this.verifyIncoming = verifyIncoming;
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        public final Builder verifyOutgoing(boolean verifyOutgoing) {
            this.verifyOutgoing = verifyOutgoing;
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        public final Builder caFile(String caFile) {
            this.caFile = Preconditions.checkNotNull(caFile, "caFile");
            this.initBits &= 0xFFFFFFFFFFF7FFFFL;
            return this;
        }

        public final Builder certFile(String certFile) {
            this.certFile = Preconditions.checkNotNull(certFile, "certFile");
            this.initBits &= 0xFFFFFFFFFFEFFFFFL;
            return this;
        }

        public final Builder keyFile(String keyFile) {
            this.keyFile = Preconditions.checkNotNull(keyFile, "keyFile");
            this.initBits &= 0xFFFFFFFFFFDFFFFFL;
            return this;
        }

        public final Builder addStartJoin(String element) {
            this.startJoinBuilder.add((Object)element);
            return this;
        }

        public final Builder addStartJoin(String ... elements) {
            this.startJoinBuilder.add(elements);
            return this;
        }

        public final Builder startJoin(Iterable<String> elements) {
            this.startJoinBuilder = ImmutableList.builder();
            return this.addAllStartJoin(elements);
        }

        public final Builder addAllStartJoin(Iterable<String> elements) {
            this.startJoinBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder uiDir(String uiDir) {
            this.uiDir = Preconditions.checkNotNull(uiDir, "uiDir");
            this.initBits &= 0xFFFFFFFFFFBFFFFFL;
            return this;
        }

        public final Builder pidFile(String pidFile) {
            this.pidFile = Preconditions.checkNotNull(pidFile, "pidFile");
            this.initBits &= 0xFFFFFFFFFF7FFFFFL;
            return this;
        }

        public final Builder enableSyslog(boolean enableSyslog) {
            this.enableSyslog = enableSyslog;
            this.initBits &= 0xFFFFFFFFFEFFFFFFL;
            return this;
        }

        public final Builder rejoinAfterLeave(boolean rejoinAfterLeave) {
            this.rejoinAfterLeave = rejoinAfterLeave;
            this.initBits &= 0xFFFFFFFFFDFFFFFFL;
            return this;
        }

        public ImmutableConfig build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfig(this.bootstrap, this.server, this.datacenter, this.dataDir, this.dnsRecursor, this.domain, this.logLevel, this.nodeName, this.clientAddr, this.bindAddr, this.advertiseAddr, this.ports, this.leaveOnTerm, this.skipLeaveOnInt, this.statsiteAddr, this.protocol, this.enableDebug, this.verifyIncoming, this.verifyOutgoing, this.caFile, this.certFile, this.keyFile, (ImmutableList)this.startJoinBuilder.build(), this.uiDir, this.pidFile, this.enableSyslog, this.rejoinAfterLeave);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bootstrap");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("server");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("datacenter");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("dataDir");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("dnsRecursor");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("domain");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("logLevel");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("nodeName");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("clientAddr");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("bindAddr");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("advertiseAddr");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("ports");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("leaveOnTerm");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("skipLeaveOnInt");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("statsiteAddr");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("protocol");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("enableDebug");
            }
            if ((this.initBits & 0x20000L) != 0L) {
                attributes.add("verifyIncoming");
            }
            if ((this.initBits & 0x40000L) != 0L) {
                attributes.add("verifyOutgoing");
            }
            if ((this.initBits & 0x80000L) != 0L) {
                attributes.add("caFile");
            }
            if ((this.initBits & 0x100000L) != 0L) {
                attributes.add("certFile");
            }
            if ((this.initBits & 0x200000L) != 0L) {
                attributes.add("keyFile");
            }
            if ((this.initBits & 0x400000L) != 0L) {
                attributes.add("uiDir");
            }
            if ((this.initBits & 0x800000L) != 0L) {
                attributes.add("pidFile");
            }
            if ((this.initBits & 0x1000000L) != 0L) {
                attributes.add("enableSyslog");
            }
            if ((this.initBits & 0x2000000L) != 0L) {
                attributes.add("rejoinAfterLeave");
            }
            return "Cannot build Config, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Config {
        Boolean bootstrap;
        Boolean server;
        String datacenter;
        String dataDir;
        String dnsRecursor;
        String domain;
        String logLevel;
        String nodeName;
        String clientAddr;
        String bindAddr;
        String advertiseAddr;
        Ports ports;
        Boolean leaveOnTerm;
        Boolean skipLeaveOnInt;
        String statsiteAddr;
        Integer protocol;
        Boolean enableDebug;
        Boolean verifyIncoming;
        Boolean verifyOutgoing;
        String caFile;
        String certFile;
        String keyFile;
        List<String> startJoin = ImmutableList.of();
        String uiDir;
        String pidFile;
        Boolean enableSyslog;
        Boolean rejoinAfterLeave;

        Json() {
        }

        @JsonProperty(value="Bootstrap")
        public void setBootstrap(boolean bootstrap) {
            this.bootstrap = bootstrap;
        }

        @JsonProperty(value="Server")
        public void setServer(boolean server) {
            this.server = server;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="DataDir")
        public void setDataDir(String dataDir) {
            this.dataDir = dataDir;
        }

        @JsonProperty(value="DNSRecursor")
        public void setDnsRecursor(String dnsRecursor) {
            this.dnsRecursor = dnsRecursor;
        }

        @JsonProperty(value="Domain")
        public void setDomain(String domain) {
            this.domain = domain;
        }

        @JsonProperty(value="LogLevel")
        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @JsonProperty(value="NodeName")
        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @JsonProperty(value="ClientAddr")
        public void setClientAddr(String clientAddr) {
            this.clientAddr = clientAddr;
        }

        @JsonProperty(value="BindAddr")
        public void setBindAddr(String bindAddr) {
            this.bindAddr = bindAddr;
        }

        @JsonProperty(value="AdvertiseAddr")
        public void setAdvertiseAddr(String advertiseAddr) {
            this.advertiseAddr = advertiseAddr;
        }

        @JsonProperty(value="Ports")
        public void setPorts(Ports ports) {
            this.ports = ports;
        }

        @JsonProperty(value="LeaveOnTerm")
        public void setLeaveOnTerm(boolean leaveOnTerm) {
            this.leaveOnTerm = leaveOnTerm;
        }

        @JsonProperty(value="SkipLeaveOnInt")
        public void setSkipLeaveOnInt(boolean skipLeaveOnInt) {
            this.skipLeaveOnInt = skipLeaveOnInt;
        }

        @JsonProperty(value="StatsiteAddr")
        public void setStatsiteAddr(String statsiteAddr) {
            this.statsiteAddr = statsiteAddr;
        }

        @JsonProperty(value="Protocol")
        public void setProtocol(int protocol) {
            this.protocol = protocol;
        }

        @JsonProperty(value="EnableDebug")
        public void setEnableDebug(boolean enableDebug) {
            this.enableDebug = enableDebug;
        }

        @JsonProperty(value="VerifyIncoming")
        public void setVerifyIncoming(boolean verifyIncoming) {
            this.verifyIncoming = verifyIncoming;
        }

        @JsonProperty(value="VerifyOutgoing")
        public void setVerifyOutgoing(boolean verifyOutgoing) {
            this.verifyOutgoing = verifyOutgoing;
        }

        @JsonProperty(value="CAFile")
        public void setCaFile(String caFile) {
            this.caFile = caFile;
        }

        @JsonProperty(value="CertFile")
        public void setCertFile(String certFile) {
            this.certFile = certFile;
        }

        @JsonProperty(value="KeyFile")
        public void setKeyFile(String keyFile) {
            this.keyFile = keyFile;
        }

        @JsonProperty(value="StartJoin")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setStartJoin(List<String> startJoin) {
            this.startJoin = startJoin;
        }

        @JsonProperty(value="UiDir")
        public void setUiDir(String uiDir) {
            this.uiDir = uiDir;
        }

        @JsonProperty(value="PidFile")
        public void setPidFile(String pidFile) {
            this.pidFile = pidFile;
        }

        @JsonProperty(value="EnableSyslog")
        public void setEnableSyslog(boolean enableSyslog) {
            this.enableSyslog = enableSyslog;
        }

        @JsonProperty(value="RejoinAfterLeave")
        public void setRejoinAfterLeave(boolean rejoinAfterLeave) {
            this.rejoinAfterLeave = rejoinAfterLeave;
        }

        @Override
        public boolean getBootstrap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getServer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDataDir() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String dnsRecursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLogLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNodeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBindAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAdvertiseAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Ports getPorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getLeaveOnTerm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getSkipLeaveOnInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatsiteAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProtocol() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getEnableDebug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getVerifyIncoming() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getVerifyOutgoing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCaFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCertFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getKeyFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getStartJoin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUiDir() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPidFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getEnableSyslog() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getRejoinAfterLeave() {
            throw new UnsupportedOperationException();
        }
    }
}

