/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.orbitz.consul.model.agent.Check;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableCheck
extends Check {
    private final String id;
    private final String name;
    private final Optional<String> notes;
    private final Optional<String> output;
    private final Optional<String> script;
    private final Optional<String> interval;
    private final Optional<String> ttl;
    private final Optional<String> http;
    private final Optional<String> tcp;
    private final Optional<String> serviceId;

    private ImmutableCheck(String id, String name, Optional<String> notes, Optional<String> output, Optional<String> script, Optional<String> interval, Optional<String> ttl, Optional<String> http, Optional<String> tcp, Optional<String> serviceId) {
        this.id = id;
        this.name = name;
        this.notes = notes;
        this.output = output;
        this.script = script;
        this.interval = interval;
        this.ttl = ttl;
        this.http = http;
        this.tcp = tcp;
        this.serviceId = serviceId;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return this.notes;
    }

    @Override
    @JsonProperty(value="Output")
    public Optional<String> getOutput() {
        return this.output;
    }

    @Override
    @JsonProperty(value="Script")
    public Optional<String> getScript() {
        return this.script;
    }

    @Override
    @JsonProperty(value="Interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return this.ttl;
    }

    @Override
    @JsonProperty(value="HTTP")
    public Optional<String> getHttp() {
        return this.http;
    }

    @Override
    @JsonProperty(value="TCP")
    public Optional<String> getTcp() {
        return this.tcp;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return this.serviceId;
    }

    public final ImmutableCheck withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(Preconditions.checkNotNull(value, "id"), this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, Preconditions.checkNotNull(value, "name"), this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withNotes(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, newValue, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withNotes(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "notes");
        if (this.notes == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, value, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withOutput(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, newValue, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withOutput(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "output");
        if (this.output == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, value, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withScript(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, newValue, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withScript(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "script");
        if (this.script == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, value, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withInterval(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, newValue, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withInterval(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "interval");
        if (this.interval == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, value, this.ttl, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withTtl(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, newValue, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withTtl(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "ttl");
        if (this.ttl == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, value, this.http, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withHttp(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, newValue, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withHttp(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "http");
        if (this.http == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, value, this.tcp, this.serviceId));
    }

    public final ImmutableCheck withTcp(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, newValue, this.serviceId));
    }

    public final ImmutableCheck withTcp(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "tcp");
        if (this.tcp == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, value, this.serviceId));
    }

    public final ImmutableCheck withServiceId(String value) {
        Optional<String> newValue = Optional.of(value);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, newValue));
    }

    public final ImmutableCheck withServiceId(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "serviceId");
        if (this.serviceId == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheck && this.equalTo((ImmutableCheck)another);
    }

    private boolean equalTo(ImmutableCheck another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.notes.equals(another.notes) && this.output.equals(another.output) && this.script.equals(another.script) && this.interval.equals(another.interval) && this.ttl.equals(another.ttl) && this.http.equals(another.http) && this.tcp.equals(another.tcp) && this.serviceId.equals(another.serviceId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.notes.hashCode();
        h = h * 17 + this.output.hashCode();
        h = h * 17 + this.script.hashCode();
        h = h * 17 + this.interval.hashCode();
        h = h * 17 + this.ttl.hashCode();
        h = h * 17 + this.http.hashCode();
        h = h * 17 + this.tcp.hashCode();
        h = h * 17 + this.serviceId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Check").add("id", this.id).add("name", this.name).add("notes", this.notes).add("output", this.output).add("script", this.script).add("interval", this.interval).add("ttl", this.ttl).add("http", this.http).add("tcp", this.tcp).add("serviceId", this.serviceId).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCheck fromJson(Json json) {
        Builder builder = ImmutableCheck.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.notes != null) {
            builder.notes(json.notes);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        if (json.script != null) {
            builder.script(json.script);
        }
        if (json.interval != null) {
            builder.interval(json.interval);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        if (json.http != null) {
            builder.http(json.http);
        }
        if (json.tcp != null) {
            builder.tcp(json.tcp);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        return builder.build();
    }

    private static ImmutableCheck validate(ImmutableCheck instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableCheck copyOf(Check instance) {
        if (instance instanceof ImmutableCheck) {
            return (ImmutableCheck)instance;
        }
        return ImmutableCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private String id;
        private String name;
        private Optional<String> notes = Optional.absent();
        private Optional<String> output = Optional.absent();
        private Optional<String> script = Optional.absent();
        private Optional<String> interval = Optional.absent();
        private Optional<String> ttl = Optional.absent();
        private Optional<String> http = Optional.absent();
        private Optional<String> tcp = Optional.absent();
        private Optional<String> serviceId = Optional.absent();

        private Builder() {
        }

        public final Builder from(Check instance) {
            Optional<String> serviceIdOptional;
            Optional<String> tcpOptional;
            Optional<String> httpOptional;
            Optional<String> ttlOptional;
            Optional<String> intervalOptional;
            Optional<String> scriptOptional;
            Optional<String> outputOptional;
            Preconditions.checkNotNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            Optional<String> notesOptional = instance.getNotes();
            if (notesOptional.isPresent()) {
                this.notes(notesOptional);
            }
            if ((outputOptional = instance.getOutput()).isPresent()) {
                this.output(outputOptional);
            }
            if ((scriptOptional = instance.getScript()).isPresent()) {
                this.script(scriptOptional);
            }
            if ((intervalOptional = instance.getInterval()).isPresent()) {
                this.interval(intervalOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            if ((httpOptional = instance.getHttp()).isPresent()) {
                this.http(httpOptional);
            }
            if ((tcpOptional = instance.getTcp()).isPresent()) {
                this.tcp(tcpOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Preconditions.checkNotNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder notes(String notes) {
            this.notes = Optional.of(notes);
            return this;
        }

        public final Builder notes(Optional<String> notes) {
            this.notes = Preconditions.checkNotNull(notes, "notes");
            return this;
        }

        public final Builder output(String output) {
            this.output = Optional.of(output);
            return this;
        }

        public final Builder output(Optional<String> output) {
            this.output = Preconditions.checkNotNull(output, "output");
            return this;
        }

        public final Builder script(String script) {
            this.script = Optional.of(script);
            return this;
        }

        public final Builder script(Optional<String> script) {
            this.script = Preconditions.checkNotNull(script, "script");
            return this;
        }

        public final Builder interval(String interval) {
            this.interval = Optional.of(interval);
            return this;
        }

        public final Builder interval(Optional<String> interval) {
            this.interval = Preconditions.checkNotNull(interval, "interval");
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = Optional.of(ttl);
            return this;
        }

        public final Builder ttl(Optional<String> ttl) {
            this.ttl = Preconditions.checkNotNull(ttl, "ttl");
            return this;
        }

        public final Builder http(String http) {
            this.http = Optional.of(http);
            return this;
        }

        public final Builder http(Optional<String> http) {
            this.http = Preconditions.checkNotNull(http, "http");
            return this;
        }

        public final Builder tcp(String tcp) {
            this.tcp = Optional.of(tcp);
            return this;
        }

        public final Builder tcp(Optional<String> tcp) {
            this.tcp = Preconditions.checkNotNull(tcp, "tcp");
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = Optional.of(serviceId);
            return this;
        }

        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
            return this;
        }

        public ImmutableCheck build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Check, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Check {
        String id;
        String name;
        Optional<String> notes = Optional.absent();
        Optional<String> output = Optional.absent();
        Optional<String> script = Optional.absent();
        Optional<String> interval = Optional.absent();
        Optional<String> ttl = Optional.absent();
        Optional<String> http = Optional.absent();
        Optional<String> tcp = Optional.absent();
        Optional<String> serviceId = Optional.absent();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="Output")
        public void setOutput(Optional<String> output) {
            this.output = output;
        }

        @JsonProperty(value="Script")
        public void setScript(Optional<String> script) {
            this.script = script;
        }

        @JsonProperty(value="Interval")
        public void setInterval(Optional<String> interval) {
            this.interval = interval;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @JsonProperty(value="HTTP")
        public void setHttp(Optional<String> http) {
            this.http = http;
        }

        @JsonProperty(value="TCP")
        public void setTcp(Optional<String> tcp) {
            this.tcp = tcp;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getScript() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHttp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTcp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }
    }
}

