/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.model.session.Session;
import com.orbitz.consul.model.session.SessionCreatedResponse;
import com.orbitz.consul.model.session.SessionInfo;
import com.orbitz.consul.util.Http;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.collect.ImmutableMap;
import com.orbitz.retrofit.Call;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.http.Body;
import com.orbitz.retrofit.http.GET;
import com.orbitz.retrofit.http.PUT;
import com.orbitz.retrofit.http.Path;
import com.orbitz.retrofit.http.QueryMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SessionClient {
    private final Api api;

    SessionClient(Retrofit retrofit) {
        this.api = retrofit.create(Api.class);
    }

    public SessionCreatedResponse createSession(Session value) {
        return this.createSession(value, null);
    }

    public SessionCreatedResponse createSession(Session value, String dc) {
        return Http.extract(this.api.createSession(value, this.dcQuery(dc)));
    }

    private Map<String, String> dcQuery(String dc) {
        Map<String, String> query = Collections.emptyMap();
        if (dc != null) {
            query = ImmutableMap.of("dc", dc);
        }
        return query;
    }

    public Optional<SessionInfo> renewSession(String sessionId) {
        return this.renewSession(null, sessionId);
    }

    public Optional<SessionInfo> renewSession(String dc, String sessionId) {
        List<SessionInfo> sessionInfo = Http.extract(this.api.renewSession(sessionId, ImmutableMap.of(), this.dcQuery(dc)));
        return sessionInfo != null && sessionInfo.isEmpty() ? Optional.absent() : Optional.of(sessionInfo.get(0));
    }

    public void destroySession(String sessionId) {
        this.destroySession(sessionId, null);
    }

    public void destroySession(String sessionId, String dc) {
        Http.handle(this.api.destroySession(sessionId, this.dcQuery(dc)));
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId) {
        return this.getSessionInfo(sessionId, null);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId, String dc) {
        List<SessionInfo> sessionInfo = Http.extract(this.api.getSessionInfo(sessionId, this.dcQuery(dc)));
        return sessionInfo != null && sessionInfo.isEmpty() ? Optional.absent() : Optional.of(sessionInfo.get(0));
    }

    public List<SessionInfo> listSessions(String dc) {
        return Http.extract(this.api.listSessions(this.dcQuery(dc)));
    }

    public List<SessionInfo> listSessions() {
        return this.listSessions(null);
    }

    static interface Api {
        @PUT(value="session/create")
        public Call<SessionCreatedResponse> createSession(@Body Session var1, @QueryMap Map<String, String> var2);

        @PUT(value="session/renew/{sessionId}")
        public Call<List<SessionInfo>> renewSession(@Path(value="sessionId") String var1, @Body Map<String, String> var2, @QueryMap Map<String, String> var3);

        @PUT(value="session/destroy/{sessionId}")
        public Call<Void> destroySession(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/info/{sessionId}")
        public Call<List<SessionInfo>> getSessionInfo(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/list")
        public Call<List<SessionInfo>> listSessions(@QueryMap Map<String, String> var1);
    }
}

