/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.AgentClient;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.EventClient;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.PreparedQueryClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.StatusClient;
import com.orbitz.consul.util.Jackson;
import com.orbitz.fasterxml.jackson.databind.ObjectMapper;
import com.orbitz.fasterxml.jackson.datatype.guava.GuavaModule;
import com.orbitz.google.common.annotations.VisibleForTesting;
import com.orbitz.google.common.net.HostAndPort;
import com.orbitz.okhttp3.OkHttpClient;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.converter.jackson.JacksonConverterFactory;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLContext;

public class Consul {
    public static final String DEFAULT_HTTP_HOST = "localhost";
    public static final int DEFAULT_HTTP_PORT = 8500;
    private final AgentClient agentClient;
    private final HealthClient healthClient;
    private final KeyValueClient keyValueClient;
    private final CatalogClient catalogClient;
    private final StatusClient statusClient;
    private final SessionClient sessionClient;
    private final EventClient eventClient;
    private final PreparedQueryClient preparedQueryClient;

    private Consul(String url, SSLContext sslContext, ObjectMapper mapper) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        try {
            URL consulUrl = new URL(url);
            if (sslContext != null) {
                builder.sslSocketFactory(sslContext.getSocketFactory());
            }
            Retrofit retrofit = new Retrofit.Builder().baseUrl(new URL(consulUrl.getProtocol(), consulUrl.getHost(), consulUrl.getPort(), "/v1/").toExternalForm()).addConverterFactory(JacksonConverterFactory.create(mapper)).client(builder.build()).build();
            this.agentClient = new AgentClient(retrofit);
            this.healthClient = new HealthClient(retrofit);
            this.keyValueClient = new KeyValueClient(retrofit);
            this.catalogClient = new CatalogClient(retrofit);
            this.statusClient = new StatusClient(retrofit);
            this.sessionClient = new SessionClient(retrofit);
            this.eventClient = new EventClient(retrofit);
            this.preparedQueryClient = new PreparedQueryClient(retrofit);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.agentClient.ping();
    }

    public AgentClient agentClient() {
        return this.agentClient;
    }

    public CatalogClient catalogClient() {
        return this.catalogClient;
    }

    public HealthClient healthClient() {
        return this.healthClient;
    }

    public KeyValueClient keyValueClient() {
        return this.keyValueClient;
    }

    public StatusClient statusClient() {
        return this.statusClient;
    }

    public SessionClient sessionClient() {
        return this.sessionClient;
    }

    public EventClient eventClient() {
        return this.eventClient;
    }

    public PreparedQueryClient preparedQueryClient() {
        return this.preparedQueryClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public static Consul newClient() {
        return Consul.builder().build();
    }

    public static class Builder {
        private URL url;
        private SSLContext sslContext;
        private ObjectMapper objectMapper = Jackson.MAPPER;

        Builder() {
            try {
                this.url = new URL("http", Consul.DEFAULT_HTTP_HOST, 8500, "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withHostAndPort(HostAndPort hostAndPort) {
            try {
                this.url = new URL("http", hostAndPort.getHostText(), hostAndPort.getPort(), "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withUrl(String url) {
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            objectMapper.registerModule(new GuavaModule());
            return this;
        }

        public Consul build() {
            return new Consul(this.url.toExternalForm(), this.sslContext, this.objectMapper);
        }
    }
}

