package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link EventOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEventOptions.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "EventOptions"})
public final class ImmutableEventOptions extends EventOptions {
  private final Optional<String> datacenter;
  private final Optional<String> nodeFilter;
  private final Optional<String> serviceFilter;
  private final Optional<String> tagFilter;

  private ImmutableEventOptions(
      Optional<String> datacenter,
      Optional<String> nodeFilter,
      Optional<String> serviceFilter,
      Optional<String> tagFilter) {
    this.datacenter = datacenter;
    this.nodeFilter = nodeFilter;
    this.serviceFilter = serviceFilter;
    this.tagFilter = tagFilter;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code nodeFilter} attribute
   */
  @Override
  public Optional<String> getNodeFilter() {
    return nodeFilter;
  }

  /**
   * @return The value of the {@code serviceFilter} attribute
   */
  @Override
  public Optional<String> getServiceFilter() {
    return serviceFilter;
  }

  /**
   * @return The value of the {@code tagFilter} attribute
   */
  @Override
  public Optional<String> getTagFilter() {
    return tagFilter;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EventOptions#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withDatacenter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(newValue, this.nodeFilter, this.serviceFilter, this.tagFilter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EventOptions#getDatacenter() datacenter} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withDatacenter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "datacenter");
    if (this.datacenter == value) return this;
    return new ImmutableEventOptions(value, this.nodeFilter, this.serviceFilter, this.tagFilter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EventOptions#getNodeFilter() nodeFilter} attribute.
   * @param value The value for nodeFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withNodeFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(this.datacenter, newValue, this.serviceFilter, this.tagFilter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EventOptions#getNodeFilter() nodeFilter} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nodeFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withNodeFilter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "nodeFilter");
    if (this.nodeFilter == value) return this;
    return new ImmutableEventOptions(this.datacenter, value, this.serviceFilter, this.tagFilter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EventOptions#getServiceFilter() serviceFilter} attribute.
   * @param value The value for serviceFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withServiceFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, newValue, this.tagFilter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EventOptions#getServiceFilter() serviceFilter} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withServiceFilter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "serviceFilter");
    if (this.serviceFilter == value) return this;
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, value, this.tagFilter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EventOptions#getTagFilter() tagFilter} attribute.
   * @param value The value for tagFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withTagFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EventOptions#getTagFilter() tagFilter} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tagFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEventOptions withTagFilter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "tagFilter");
    if (this.tagFilter == value) return this;
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEventOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEventOptions
        && equalTo((ImmutableEventOptions) another);
  }

  private boolean equalTo(ImmutableEventOptions another) {
    return datacenter.equals(another.datacenter)
        && nodeFilter.equals(another.nodeFilter)
        && serviceFilter.equals(another.serviceFilter)
        && tagFilter.equals(another.tagFilter);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code nodeFilter}, {@code serviceFilter}, {@code tagFilter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + nodeFilter.hashCode();
    h = h * 17 + serviceFilter.hashCode();
    h = h * 17 + tagFilter.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EventOptions...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EventOptions")
        .add("datacenter", datacenter)
        .add("nodeFilter", nodeFilter)
        .add("serviceFilter", serviceFilter)
        .add("tagFilter", tagFilter)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link EventOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EventOptions instance
   */
  public static ImmutableEventOptions copyOf(EventOptions instance) {
    if (instance instanceof ImmutableEventOptions) {
      return (ImmutableEventOptions) instance;
    }
    return ImmutableEventOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEventOptions ImmutableEventOptions}.
   * @return A new ImmutableEventOptions builder
   */
  public static ImmutableEventOptions.Builder builder() {
    return new ImmutableEventOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEventOptions ImmutableEventOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Optional<String> datacenter = Optional.absent();
    private Optional<String> nodeFilter = Optional.absent();
    private Optional<String> serviceFilter = Optional.absent();
    private Optional<String> tagFilter = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EventOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EventOptions instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      Optional<String> nodeFilterOptional = instance.getNodeFilter();
      if (nodeFilterOptional.isPresent()) {
        nodeFilter(nodeFilterOptional);
      }
      Optional<String> serviceFilterOptional = instance.getServiceFilter();
      if (serviceFilterOptional.isPresent()) {
        serviceFilter(serviceFilterOptional);
      }
      Optional<String> tagFilterOptional = instance.getTagFilter();
      if (tagFilterOptional.isPresent()) {
        tagFilter(tagFilterOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Optional.of(datacenter);
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getNodeFilter() nodeFilter} to nodeFilter.
     * @param nodeFilter The value for nodeFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeFilter(String nodeFilter) {
      this.nodeFilter = Optional.of(nodeFilter);
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getNodeFilter() nodeFilter} to nodeFilter.
     * @param nodeFilter The value for nodeFilter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeFilter(Optional<String> nodeFilter) {
      this.nodeFilter = Preconditions.checkNotNull(nodeFilter, "nodeFilter");
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getServiceFilter() serviceFilter} to serviceFilter.
     * @param serviceFilter The value for serviceFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceFilter(String serviceFilter) {
      this.serviceFilter = Optional.of(serviceFilter);
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getServiceFilter() serviceFilter} to serviceFilter.
     * @param serviceFilter The value for serviceFilter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceFilter(Optional<String> serviceFilter) {
      this.serviceFilter = Preconditions.checkNotNull(serviceFilter, "serviceFilter");
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getTagFilter() tagFilter} to tagFilter.
     * @param tagFilter The value for tagFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder tagFilter(String tagFilter) {
      this.tagFilter = Optional.of(tagFilter);
      return this;
    }

    /**
     * Initializes the optional value {@link EventOptions#getTagFilter() tagFilter} to tagFilter.
     * @param tagFilter The value for tagFilter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tagFilter(Optional<String> tagFilter) {
      this.tagFilter = Preconditions.checkNotNull(tagFilter, "tagFilter");
      return this;
    }

    /**
     * Builds a new {@link ImmutableEventOptions ImmutableEventOptions}.
     * @return An immutable instance of EventOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEventOptions build() throws IllegalStateException {
      return new ImmutableEventOptions(datacenter, nodeFilter, serviceFilter, tagFilter);
    }
  }
}
