package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Registration.RegCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRegCheck.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Registration.RegCheck"})
public final class ImmutableRegCheck extends Registration.RegCheck {
  private final Optional<String> script;
  private final Optional<String> interval;
  private final Optional<String> ttl;
  private final Optional<String> http;
  private final Optional<String> tcp;

  private ImmutableRegCheck(
      Optional<String> script,
      Optional<String> interval,
      Optional<String> ttl,
      Optional<String> http,
      Optional<String> tcp) {
    this.script = script;
    this.interval = interval;
    this.ttl = ttl;
    this.http = http;
    this.tcp = tcp;
  }

  /**
   * @return The value of the {@code script} attribute
   */
  @JsonProperty(value = "Script")
  @Override
  public Optional<String> getScript() {
    return script;
  }

  /**
   * @return The value of the {@code interval} attribute
   */
  @JsonProperty(value = "Interval")
  @Override
  public Optional<String> getInterval() {
    return interval;
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty(value = "TTL")
  @Override
  public Optional<String> getTtl() {
    return ttl;
  }

  /**
   * @return The value of the {@code http} attribute
   */
  @JsonProperty(value = "HTTP")
  @Override
  public Optional<String> getHttp() {
    return http;
  }

  /**
   * @return The value of the {@code tcp} attribute
   */
  @JsonProperty(value = "TCP")
  @Override
  public Optional<String> getTcp() {
    return tcp;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getScript() script} attribute.
   * @param value The value for script
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withScript(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(newValue, this.interval, this.ttl, this.http, this.tcp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getScript() script} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for script
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withScript(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "script");
    if (this.script == value) return this;
    return validate(new ImmutableRegCheck(value, this.interval, this.ttl, this.http, this.tcp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getInterval() interval} attribute.
   * @param value The value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withInterval(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(this.script, newValue, this.ttl, this.http, this.tcp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getInterval() interval} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withInterval(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "interval");
    if (this.interval == value) return this;
    return validate(new ImmutableRegCheck(this.script, value, this.ttl, this.http, this.tcp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getTtl() ttl} attribute.
   * @param value The value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTtl(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(this.script, this.interval, newValue, this.http, this.tcp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getTtl() ttl} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTtl(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "ttl");
    if (this.ttl == value) return this;
    return validate(new ImmutableRegCheck(this.script, this.interval, value, this.http, this.tcp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getHttp() http} attribute.
   * @param value The value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withHttp(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, newValue, this.tcp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getHttp() http} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withHttp(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "http");
    if (this.http == value) return this;
    return validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, value, this.tcp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getTcp() tcp} attribute.
   * @param value The value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTcp(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getTcp() tcp} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTcp(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "tcp");
    if (this.tcp == value) return this;
    return validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRegCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRegCheck
        && equalTo((ImmutableRegCheck) another);
  }

  private boolean equalTo(ImmutableRegCheck another) {
    return script.equals(another.script)
        && interval.equals(another.interval)
        && ttl.equals(another.ttl)
        && http.equals(another.http)
        && tcp.equals(another.tcp);
  }

  /**
   * Computes a hash code from attributes: {@code script}, {@code interval}, {@code ttl}, {@code http}, {@code tcp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + script.hashCode();
    h = h * 17 + interval.hashCode();
    h = h * 17 + ttl.hashCode();
    h = h * 17 + http.hashCode();
    h = h * 17 + tcp.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RegCheck...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RegCheck")
        .add("script", script)
        .add("interval", interval)
        .add("ttl", ttl)
        .add("http", http)
        .add("tcp", tcp)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Registration.RegCheck {
    Optional<String> script = Optional.absent();
    Optional<String> interval = Optional.absent();
    Optional<String> ttl = Optional.absent();
    Optional<String> http = Optional.absent();
    Optional<String> tcp = Optional.absent();
    @JsonProperty(value = "Script")
    public void setScript(Optional<String> script) {
      this.script = script;
    }
    @JsonProperty(value = "Interval")
    public void setInterval(Optional<String> interval) {
      this.interval = interval;
    }
    @JsonProperty(value = "TTL")
    public void setTtl(Optional<String> ttl) {
      this.ttl = ttl;
    }
    @JsonProperty(value = "HTTP")
    public void setHttp(Optional<String> http) {
      this.http = http;
    }
    @JsonProperty(value = "TCP")
    public void setTcp(Optional<String> tcp) {
      this.tcp = tcp;
    }
    @Override
    public Optional<String> getScript() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInterval() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTtl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHttp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTcp() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableRegCheck fromJson(Json json) {
    ImmutableRegCheck.Builder builder = ImmutableRegCheck.builder();
    if (json.script != null) {
      builder.script(json.script);
    }
    if (json.interval != null) {
      builder.interval(json.interval);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    if (json.http != null) {
      builder.http(json.http);
    }
    if (json.tcp != null) {
      builder.tcp(json.tcp);
    }
    return builder.build();
  }

  private static ImmutableRegCheck validate(ImmutableRegCheck instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Registration.RegCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RegCheck instance
   */
  public static ImmutableRegCheck copyOf(Registration.RegCheck instance) {
    if (instance instanceof ImmutableRegCheck) {
      return (ImmutableRegCheck) instance;
    }
    return ImmutableRegCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRegCheck ImmutableRegCheck}.
   * @return A new ImmutableRegCheck builder
   */
  public static ImmutableRegCheck.Builder builder() {
    return new ImmutableRegCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRegCheck ImmutableRegCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Optional<String> script = Optional.absent();
    private Optional<String> interval = Optional.absent();
    private Optional<String> ttl = Optional.absent();
    private Optional<String> http = Optional.absent();
    private Optional<String> tcp = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RegCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Registration.RegCheck instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> scriptOptional = instance.getScript();
      if (scriptOptional.isPresent()) {
        script(scriptOptional);
      }
      Optional<String> intervalOptional = instance.getInterval();
      if (intervalOptional.isPresent()) {
        interval(intervalOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      Optional<String> httpOptional = instance.getHttp();
      if (httpOptional.isPresent()) {
        http(httpOptional);
      }
      Optional<String> tcpOptional = instance.getTcp();
      if (tcpOptional.isPresent()) {
        tcp(tcpOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getScript() script} to script.
     * @param script The value for script
     * @return {@code this} builder for chained invocation
     */
    public final Builder script(String script) {
      this.script = Optional.of(script);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getScript() script} to script.
     * @param script The value for script
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder script(Optional<String> script) {
      this.script = Preconditions.checkNotNull(script, "script");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for chained invocation
     */
    public final Builder interval(String interval) {
      this.interval = Optional.of(interval);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder interval(Optional<String> interval) {
      this.interval = Preconditions.checkNotNull(interval, "interval");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Optional.of(ttl);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = Preconditions.checkNotNull(ttl, "ttl");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(String http) {
      this.http = Optional.of(http);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder http(Optional<String> http) {
      this.http = Preconditions.checkNotNull(http, "http");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for chained invocation
     */
    public final Builder tcp(String tcp) {
      this.tcp = Optional.of(tcp);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcp(Optional<String> tcp) {
      this.tcp = Preconditions.checkNotNull(tcp, "tcp");
      return this;
    }

    /**
     * Builds a new {@link ImmutableRegCheck ImmutableRegCheck}.
     * @return An immutable instance of RegCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRegCheck build() throws IllegalStateException {
      return ImmutableRegCheck.validate(new ImmutableRegCheck(script, interval, ttl, http, tcp));
    }
  }
}
