package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Agent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAgent.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Agent"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableAgent extends Agent {
  private final Config config;
  private final Member member;

  private ImmutableAgent(Config config, Member member) {
    this.config = config;
    this.member = member;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty(value = "Config")
  @Override
  public Config getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code member} attribute
   */
  @JsonProperty(value = "Member")
  @Override
  public Member getMember() {
    return member;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getConfig() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withConfig(Config value) {
    if (this.config == value) return this;
    return new ImmutableAgent(Preconditions.checkNotNull(value, "config"), this.member);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getMember() member} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for member
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withMember(Member value) {
    if (this.member == value) return this;
    return new ImmutableAgent(this.config, Preconditions.checkNotNull(value, "member"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAgent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAgent
        && equalTo((ImmutableAgent) another);
  }

  private boolean equalTo(ImmutableAgent another) {
    return config.equals(another.config)
        && member.equals(another.member);
  }

  /**
   * Computes a hash code from attributes: {@code config}, {@code member}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + member.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Agent...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Agent")
        .add("config", config)
        .add("member", member)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Agent {
    Config config;
    Member member;
    @JsonProperty(value = "Config")
    public void setConfig(Config config) {
      this.config = config;
    }
    @JsonProperty(value = "Member")
    public void setMember(Member member) {
      this.member = member;
    }
    @Override
    public Config getConfig() { throw new UnsupportedOperationException(); }
    @Override
    public Member getMember() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableAgent fromJson(Json json) {
    ImmutableAgent.Builder builder = ImmutableAgent.builder();
    if (json.config != null) {
      builder.config(json.config);
    }
    if (json.member != null) {
      builder.member(json.member);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Agent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Agent instance
   */
  public static ImmutableAgent copyOf(Agent instance) {
    if (instance instanceof ImmutableAgent) {
      return (ImmutableAgent) instance;
    }
    return ImmutableAgent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAgent ImmutableAgent}.
   * @return A new ImmutableAgent builder
   */
  public static ImmutableAgent.Builder builder() {
    return new ImmutableAgent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAgent ImmutableAgent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CONFIG = 0x1L;
    private static final long INIT_BIT_MEMBER = 0x2L;
    private long initBits = 0x3;

    private Config config;
    private Member member;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Agent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Agent instance) {
      Preconditions.checkNotNull(instance, "instance");
      config(instance.getConfig());
      member(instance.getMember());
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getConfig() config} attribute.
     * @param config The value for config 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder config(Config config) {
      this.config = Preconditions.checkNotNull(config, "config");
      initBits &= ~INIT_BIT_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getMember() member} attribute.
     * @param member The value for member 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(Member member) {
      this.member = Preconditions.checkNotNull(member, "member");
      initBits &= ~INIT_BIT_MEMBER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAgent ImmutableAgent}.
     * @return An immutable instance of Agent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAgent build() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAgent(config, member);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_CONFIG) != 0) attributes.add("config");
      if ((initBits & INIT_BIT_MEMBER) != 0) attributes.add("member");
      return "Cannot build Agent, some of required attributes are not set " + attributes;
    }
  }
}
