package com.orbitz.consul.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.util.Base64EncodingDeserializer;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Event}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableEvent.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Event"})
public final class ImmutableEvent extends Event {
  private final String id;
  private final String name;
  private final Optional<String> payload;
  private final Optional<String> nodeFilter;
  private final Optional<String> serviceFilter;
  private final Optional<String> tagFilter;
  private final int version;
  private final Long lTime;

  private ImmutableEvent(
      String id,
      String name,
      Optional<String> payload,
      Optional<String> nodeFilter,
      Optional<String> serviceFilter,
      Optional<String> tagFilter,
      int version,
      Long lTime) {
    this.id = id;
    this.name = name;
    this.payload = payload;
    this.nodeFilter = nodeFilter;
    this.serviceFilter = serviceFilter;
    this.tagFilter = tagFilter;
    this.version = version;
    this.lTime = lTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code payload} attribute
   */
  @JsonDeserialize(using = Base64EncodingDeserializer.class)
  @JsonProperty("Payload")
  @Override
  public Optional<String> getPayload() {
    return payload;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code nodeFilter} attribute
   */
  @JsonProperty("NodeFilter")
  @Override
  public Optional<String> getNodeFilter() {
    return nodeFilter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceFilter} attribute
   */
  @JsonProperty("ServiceFilter")
  @Override
  public Optional<String> getServiceFilter() {
    return serviceFilter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code tagFilter} attribute
   */
  @JsonProperty("TagFilter")
  @Override
  public Optional<String> getTagFilter() {
    return tagFilter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("Version")
  @Override
  public int getVersion() {
    return version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code lTime} attribute
   */
  @JsonProperty("LTime")
  @Override
  public Long getLTime() {
    return lTime;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Event#getId() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final ImmutableEvent withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableEvent(
        newValue,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Event#getName() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableEvent withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableEvent(
        this.id,
        newValue,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Event#getPayload() payload}.
   * @param value value for payload
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withPayload(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEvent(
        this.id,
        this.name,
        newValue,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Event#getPayload() payload}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for payload
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withPayload(Optional<String> optional) {
    if (this.payload == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEvent(
        this.id,
        this.name,
        newValue,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Event#getNodeFilter() nodeFilter}.
   * @param value value for nodeFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withNodeFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        newValue,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Event#getNodeFilter() nodeFilter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for nodeFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withNodeFilter(Optional<String> optional) {
    if (this.nodeFilter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        newValue,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Event#getServiceFilter() serviceFilter}.
   * @param value value for serviceFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withServiceFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        newValue,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Event#getServiceFilter() serviceFilter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for serviceFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withServiceFilter(Optional<String> optional) {
    if (this.serviceFilter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        newValue,
        this.tagFilter,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Event#getTagFilter() tagFilter}.
   * @param value value for tagFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withTagFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        newValue,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Event#getTagFilter() tagFilter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for tagFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEvent withTagFilter(Optional<String> optional) {
    if (this.tagFilter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        newValue,
        this.version,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Event#getVersion() version}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final ImmutableEvent withVersion(int value) {
    if (this.version == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        newValue,
        this.lTime);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Event#getLTime() lTime}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for lTime
   * @return modified copy of the {@code this} object
   */
  public final ImmutableEvent withLTime(Long value) {
    if (this.lTime == value) {
      return this;
    }
    Long newValue = Preconditions.checkNotNull(value);
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableEvent} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableEvent && equalTo((ImmutableEvent) another));
  }
  
  private boolean equalTo(ImmutableEvent another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && payload.equals(another.payload)
        && nodeFilter.equals(another.nodeFilter)
        && serviceFilter.equals(another.serviceFilter)
        && tagFilter.equals(another.tagFilter)
        && version == another.version
        && lTime.equals(another.lTime);
  }
  
  /**
   * Computes hash code from attributes: {@code id}, {@code name}, {@code payload}, {@code nodeFilter}, {@code serviceFilter}, {@code tagFilter}, {@code version}, {@code lTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + payload.hashCode();
    h = h * 17 + nodeFilter.hashCode();
    h = h * 17 + serviceFilter.hashCode();
    h = h * 17 + tagFilter.hashCode();
    h = h * 17 + version;
    h = h * 17 + lTime.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Event{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Event")
        .add("id", id)
        .add("name", name)
        .add("payload", payload)
        .add("nodeFilter", nodeFilter)
        .add("serviceFilter", serviceFilter)
        .add("tagFilter", tagFilter)
        .add("version", version)
        .add("lTime", lTime)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableEvent fromAllAttributes(
      @JsonProperty("ID") String id,
      @JsonProperty("Name") String name,
      @JsonDeserialize(using = Base64EncodingDeserializer.class)
      @JsonProperty("Payload") Optional<String> payload,
      @JsonProperty("NodeFilter") Optional<String> nodeFilter,
      @JsonProperty("ServiceFilter") Optional<String> serviceFilter,
      @JsonProperty("TagFilter") Optional<String> tagFilter,
      @JsonProperty("Version") Integer version,
      @JsonProperty("LTime") Long lTime) {
    ImmutableEvent.Builder builder = ImmutableEvent.builder();
    if (id != null) {
      builder.id(id);
    }
    if (name != null) {
      builder.name(name);
    }
    if (payload != null) {
      builder.payload(payload);
    }
    if (nodeFilter != null) {
      builder.nodeFilter(nodeFilter);
    }
    if (serviceFilter != null) {
      builder.serviceFilter(serviceFilter);
    }
    if (tagFilter != null) {
      builder.tagFilter(tagFilter);
    }
    if (version != null) {
      builder.version(version);
    }
    if (lTime != null) {
      builder.lTime(lTime);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Event}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Event instance
   */
  public static ImmutableEvent copyOf(Event instance) {
    if (instance instanceof ImmutableEvent) {
      return (ImmutableEvent) instance;
    }
    return ImmutableEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.event.ImmutableEvent}.
   * @return new ImmutableEvent builder
   */
  public static ImmutableEvent.Builder builder() {
    return new ImmutableEvent.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.event.ImmutableEvent}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private static final long INITIALIZED_BIT_NAME = 0x2L;
    private static final long INITIALIZED_BIT_VERSION = 0x4L;
    private static final long INITIALIZED_BIT_L_TIME = 0x8L;
    private long initializedBitset;
  
    private String id;
    private String name;
    private Optional<String> payload = Optional.absent();
    private Optional<String> nodeFilter = Optional.absent();
    private Optional<String> serviceFilter = Optional.absent();
    private Optional<String> tagFilter = Optional.absent();
    private int version;
    private Long lTime;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Event} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Event instance) {
      Preconditions.checkNotNull(instance);
      id(instance.getId());
      name(instance.getName());
      Optional<String> payloadOptional = instance.getPayload();
      if (payloadOptional.isPresent()) {
        payload(payloadOptional);
      }
      Optional<String> nodeFilterOptional = instance.getNodeFilter();
      if (nodeFilterOptional.isPresent()) {
        nodeFilter(nodeFilterOptional);
      }
      Optional<String> serviceFilterOptional = instance.getServiceFilter();
      if (serviceFilterOptional.isPresent()) {
        serviceFilter(serviceFilterOptional);
      }
      Optional<String> tagFilterOptional = instance.getTagFilter();
      if (tagFilterOptional.isPresent()) {
        tagFilter(tagFilterOptional);
      }
      version(instance.getVersion());
      lTime(instance.getLTime());
      return this;
    }
  
    /**
     * Initializes value for {@link Event#getId() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link Event#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Event#getPayload() payload}.
     * @param payload value for payload
     * @return {@code this} builder for chained invocation
     */
    public final Builder payload(String payload) {
      this.payload = Optional.of(payload);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Event#getPayload() payload}.
     * @param payload value for payload
     * @return {@code this} builder for chained invocation
     */
    public final Builder payload(Optional<String> payload) {
      this.payload = Preconditions.checkNotNull(payload);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Event#getNodeFilter() nodeFilter}.
     * @param nodeFilter value for nodeFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeFilter(String nodeFilter) {
      this.nodeFilter = Optional.of(nodeFilter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Event#getNodeFilter() nodeFilter}.
     * @param nodeFilter value for nodeFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeFilter(Optional<String> nodeFilter) {
      this.nodeFilter = Preconditions.checkNotNull(nodeFilter);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Event#getServiceFilter() serviceFilter}.
     * @param serviceFilter value for serviceFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceFilter(String serviceFilter) {
      this.serviceFilter = Optional.of(serviceFilter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Event#getServiceFilter() serviceFilter}.
     * @param serviceFilter value for serviceFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceFilter(Optional<String> serviceFilter) {
      this.serviceFilter = Preconditions.checkNotNull(serviceFilter);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Event#getTagFilter() tagFilter}.
     * @param tagFilter value for tagFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder tagFilter(String tagFilter) {
      this.tagFilter = Optional.of(tagFilter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Event#getTagFilter() tagFilter}.
     * @param tagFilter value for tagFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder tagFilter(Optional<String> tagFilter) {
      this.tagFilter = Preconditions.checkNotNull(tagFilter);
      return this;
    }
  
    /**
     * Initializes value for {@link Event#getVersion() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(int version) {
      this.version = version;
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Initializes value for {@link Event#getLTime() lTime}.
     * @param lTime value for lTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder lTime(Long lTime) {
      this.lTime = Preconditions.checkNotNull(lTime);
      initializedBitset |= INITIALIZED_BIT_L_TIME;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.event.ImmutableEvent}.
     * @return immutable instance of Event
     */
    public ImmutableEvent build() {
      checkRequiredAttributes();
      return new ImmutableEvent(id, name, payload, nodeFilter, serviceFilter, tagFilter, version, lTime);
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private boolean lTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_L_TIME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      if (!lTimeIsSet()) {
        attributes.add("lTime");
      }
      return "Cannot build Event, some of required attributes are not set " + attributes;
    }
  }
}
