/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.weblogic.rewrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oracle.weblogic.rewrite.WeblogicVersionHelper;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeWeblogicMavenPropertyVersion
extends Recipe {
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="14.1.2-0-0")
    private final String newVersion;

    @JsonCreator
    public UpgradeWeblogicMavenPropertyVersion(@JsonProperty(value="newVersion") String newVersion) {
        this.newVersion = newVersion;
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, null));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade `weblogic.version` Maven property";
    }

    public String getDescription() {
        return "Set the Maven weblogic.version property according to a node-style semver selector or to a specific version number.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, (Object)ctx);
                MavenResolutionResult model = this.getResolutionResult();
                String currentVersion = (String)model.getPom().getProperties().get("weblogic.version");
                if (currentVersion != null && !currentVersion.isEmpty()) {
                    try {
                        Optional<String> latestVersion = WeblogicVersionHelper.getNewerVersion(UpgradeWeblogicMavenPropertyVersion.this.newVersion, currentVersion, ctx);
                        if (latestVersion.isPresent()) {
                            System.out.printf("Upgrading weblogic.version from %s to %s%n", currentVersion, latestVersion.get());
                            this.doAfterVisit(new ChangePropertyValue("weblogic.version", latestVersion.get(), Boolean.valueOf(false), Boolean.valueOf(true)).getVisitor());
                        } else {
                            System.out.printf("No newer version found for weblogic.version: %s%n", currentVersion);
                        }
                    }
                    catch (Exception e) {
                        return (Xml.Document)Markup.warn((Tree)document, (Throwable)e);
                    }
                }
                return d;
            }
        };
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public String toString() {
        return "UpgradeWeblogicMavenPropertyVersion(newVersion=" + this.getNewVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeWeblogicMavenPropertyVersion)) {
            return false;
        }
        UpgradeWeblogicMavenPropertyVersion other = (UpgradeWeblogicMavenPropertyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeWeblogicMavenPropertyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

