/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.columns;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumns;

/**
 * Object to hold onto XML primary key join column metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLPrimaryKeyJoinColumns extends MetadataPrimaryKeyJoinColumns {    
    /**
     * INTERNAL:
     */
    public XMLPrimaryKeyJoinColumns(Node node, XMLHelper helper, String sourceTableName, String targetTableName) {
        super(sourceTableName, targetTableName);

        // Process the primary-key-join-column nodes.        
        NodeList nodes = helper.getNodes(node, XMLConstants.PK_JOIN_COLUMN);

        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); i++) {
                m_pkJoinColumns.add(new XMLPrimaryKeyJoinColumn(nodes.item(i), helper, sourceTableName, targetTableName));
            }
		}
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return true;
    }
}
