/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_METADATA})
public class SQLName
implements Serializable {
    static boolean DEBUG;
    static boolean s_parseAllFormat;
    static final long serialVersionUID = 2266340348729491526L;
    String name;
    String schema;
    String simple;
    int version;
    boolean synonym;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    protected SQLName() {
    }

    public SQLName(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, SQLName.class, $$$methodRef$$$10, null, string, oracleConnection);
            }
            this.init(string, oracleConnection);
            this.version = 2;
            this.synonym = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, SQLName.class, $$$methodRef$$$10, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SQLName.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SQLName.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public SQLName(String string, String string2, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, SQLName.class, $$$methodRef$$$11, null, string, string2, oracleConnection);
            }
            this.schema = SQLName.replaceQuotes(string);
            this.simple = SQLName.replaceQuotes(string2);
            this.name = this.schema + "." + this.simple;
            this.version = 2;
            this.synonym = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, SQLName.class, $$$methodRef$$$11, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SQLName.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SQLName.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    private void init(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        if (SQLName.parse(string, stringArray, stringArray2, true)) {
            this.schema = SQLName.replaceQuotes(stringArray[0]);
            this.simple = SQLName.replaceQuotes(stringArray2[0]);
        } else {
            this.schema = SQLName.replaceQuotes(oracleConnection.physicalConnectionWithin().getDefaultSchemaNameForNamedTypes());
            this.simple = SQLName.replaceQuotes(stringArray2[0]);
        }
        this.name = this.schema + "." + this.simple;
    }

    @DisableTrace
    public String getName() throws SQLException {
        return this.name;
    }

    @DisableTrace
    public String getSchema() throws SQLException {
        return this.schema;
    }

    @DisableTrace
    public String getSimpleName() throws SQLException {
        return this.simple;
    }

    @DisableTrace
    public int getVersion() throws SQLException {
        return this.version;
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, SQLName.class, $$$methodRef$$$1, null, string, stringArray, stringArray2);
            }
            boolean bl2 = SQLName.parse(string, stringArray, stringArray2, s_parseAllFormat);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SQLName.class, $$$methodRef$$$1, null, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SQLName.class, $$$methodRef$$$1, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SQLName.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, string, stringArray, stringArray2, bl);
            }
            if (string == null) {
                boolean bl3 = false;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl3);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                }
                return false;
            }
            if (stringArray == null || stringArray.length < 1 || stringArray2 == null || stringArray2.length < 1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, sQLException);
                }
                throw sQLException;
            }
            if (!bl) {
                int n2 = string.indexOf(".");
                if (n2 < 0) {
                    stringArray2[0] = string;
                    boolean bl4 = false;
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl4);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                    }
                    return false;
                }
                stringArray[0] = string.substring(0, n2);
                stringArray2[0] = string.substring(n2 + 1);
                boolean bl5 = true;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl5);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                }
                return true;
            }
            int n3 = string.length();
            int n4 = string.indexOf("\"");
            int n5 = string.indexOf("\"", n4 + 1);
            int n6 = -1;
            if (n4 < 0) {
                n6 = string.indexOf(".");
                if (n6 < 0) {
                    stringArray2[0] = string;
                    boolean bl6 = false;
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl6);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                    }
                    return false;
                }
                stringArray[0] = string.substring(0, n6);
                stringArray2[0] = string.substring(n6 + 1);
                boolean bl7 = true;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl7);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                }
                return true;
            }
            if (n4 == 0) {
                if (n5 == n3 - 1) {
                    stringArray2[0] = string.substring(n4 + 1, n5);
                    boolean bl8 = false;
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl8);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                    }
                    return false;
                }
                n6 = string.indexOf(".", n5);
                stringArray[0] = string.substring(n4 + 1, n5);
                n4 = string.indexOf("\"", n6);
                n5 = string.indexOf("\"", n4 + 1);
                if (n4 < 0) {
                    stringArray2[0] = string.substring(n6 + 1);
                    boolean bl9 = true;
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl9);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                    }
                    return true;
                }
                int n7 = string.indexOf(".", n6 + 1);
                stringArray2[0] = n7 == -1 ? string.substring(n4 + 1, n5) : SQLName.replaceQuotes(string.substring(n6 + 1));
                boolean bl10 = true;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl10);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
                }
                return true;
            }
            n6 = string.indexOf(".");
            stringArray[0] = string.substring(0, n6);
            int n8 = string.indexOf(".", n6 + 1);
            stringArray2[0] = n8 == -1 ? string.substring(n4 + 1, n5) : SQLName.replaceQuotes(string.substring(n6 + 1));
            boolean bl11 = true;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, bl11);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLName.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static void setHandleDoubleQuote(boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, SQLName.class, $$$methodRef$$$3, null, bl);
            }
            s_parseAllFormat = bl;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SQLName.class, $$$methodRef$$$3, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SQLName.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SQLName.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean getHandleDoubleQuote() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, SQLName.class, $$$methodRef$$$4, null, new Object[0]);
            }
            boolean bl2 = s_parseAllFormat;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SQLName.class, $$$methodRef$$$4, null, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SQLName.class, $$$methodRef$$$4, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SQLName.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SQLName)) {
            return false;
        }
        return ((SQLName)object).name.equals(this.name);
    }

    @DisableTrace
    public int hashCode() {
        return this.name == null ? -1 : this.name.hashCode();
    }

    @DisableTrace
    public String toString() {
        return this.name;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeUTF(this.schema);
        objectOutputStream.writeUTF(this.simple);
        objectOutputStream.writeInt(this.version);
        objectOutputStream.writeBoolean(this.synonym);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.schema = objectInputStream.readUTF();
        this.simple = objectInputStream.readUTF();
        this.version = objectInputStream.readInt();
        this.synonym = objectInputStream.readBoolean();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static String replaceQuotes(String string) {
        if (string.indexOf(34) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '\"') continue;
            cArray2[n2++] = cArray[i2];
        }
        return String.valueOf(cArray2, 0, n2);
    }

    static {
        try {
            $$$methodRef$$$11 = SQLName.class.getDeclaredConstructor(String.class, String.class, oracle.jdbc.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = SQLName.class.getDeclaredConstructor(String.class, oracle.jdbc.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = SQLName.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = SQLName.class.getDeclaredMethod("replaceQuotes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = SQLName.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = SQLName.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = SQLName.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = SQLName.class.getDeclaredMethod("getHandleDoubleQuote", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = SQLName.class.getDeclaredMethod("setHandleDoubleQuote", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = SQLName.class.getDeclaredMethod("parse", String.class, String[].class, String[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = SQLName.class.getDeclaredMethod("parse", String.class, String[].class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = SQLName.class.getDeclaredMethod("init", String.class, oracle.jdbc.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        DEBUG = false;
        s_parseAllFormat = false;
    }
}

