/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.RowSetMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleRowSetMetaData
implements RowSetMetaData,
Serializable {
    private int columnCount;
    private int[] nullable;
    private int[] columnDisplaySize;
    private int[] precision;
    private int[] scale;
    private int[] columnType;
    private boolean[] searchable;
    private boolean[] caseSensitive;
    private boolean[] readOnly;
    private boolean[] writable;
    private boolean[] definatelyWritable;
    private boolean[] currency;
    private boolean[] autoIncrement;
    private boolean[] signed;
    private String[] columnLabel;
    private String[] schemaName;
    private String[] columnName;
    private String[] tableName;
    private String[] columnTypeName;
    private String[] catalogName;
    private String[] columnClassName;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;

    OracleRowSetMetaData(int n2) throws SQLException {
        this.columnCount = n2;
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            this.searchable[i2] = false;
            this.caseSensitive[i2] = false;
            this.readOnly[i2] = false;
            this.nullable[i2] = 1;
            this.signed[i2] = false;
            this.columnDisplaySize[i2] = 0;
            this.columnType[i2] = 0;
            this.columnLabel[i2] = "";
            this.columnName[i2] = "";
            this.schemaName[i2] = "";
            this.precision[i2] = 0;
            this.scale[i2] = 0;
            this.tableName[i2] = "";
            this.columnTypeName[i2] = "";
            this.writable[i2] = false;
            this.definatelyWritable[i2] = false;
            this.currency[i2] = false;
            this.autoIncrement[i2] = true;
            this.catalogName[i2] = "";
            this.columnClassName[i2] = "";
        }
    }

    OracleRowSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.columnCount = resultSetMetaData.getColumnCount();
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            this.searchable[i2] = resultSetMetaData.isSearchable(i2 + 1);
            this.caseSensitive[i2] = resultSetMetaData.isCaseSensitive(i2 + 1);
            this.readOnly[i2] = resultSetMetaData.isReadOnly(i2 + 1);
            this.nullable[i2] = resultSetMetaData.isNullable(i2 + 1);
            this.signed[i2] = resultSetMetaData.isSigned(i2 + 1);
            this.columnDisplaySize[i2] = resultSetMetaData.getColumnDisplaySize(i2 + 1);
            this.columnType[i2] = resultSetMetaData.getColumnType(i2 + 1);
            this.columnLabel[i2] = resultSetMetaData.getColumnLabel(i2 + 1);
            this.columnName[i2] = resultSetMetaData.getColumnName(i2 + 1);
            this.schemaName[i2] = resultSetMetaData.getSchemaName(i2 + 1);
            if (this.columnType[i2] == 2 || this.columnType[i2] == 2 || this.columnType[i2] == -5 || this.columnType[i2] == 3 || this.columnType[i2] == 8 || this.columnType[i2] == 6 || this.columnType[i2] == 4) {
                this.precision[i2] = resultSetMetaData.getPrecision(i2 + 1);
                this.scale[i2] = resultSetMetaData.getScale(i2 + 1);
            } else {
                this.precision[i2] = 0;
                this.scale[i2] = 0;
            }
            this.tableName[i2] = resultSetMetaData.getTableName(i2 + 1);
            this.columnTypeName[i2] = resultSetMetaData.getColumnTypeName(i2 + 1);
            this.writable[i2] = resultSetMetaData.isWritable(i2 + 1);
            this.definatelyWritable[i2] = resultSetMetaData.isDefinitelyWritable(i2 + 1);
            this.currency[i2] = resultSetMetaData.isCurrency(i2 + 1);
            this.autoIncrement[i2] = resultSetMetaData.isAutoIncrement(i2 + 1);
            this.catalogName[i2] = resultSetMetaData.getCatalogName(i2 + 1);
            this.columnClassName[i2] = resultSetMetaData.getColumnClassName(i2 + 1);
        }
    }

    private void validateColumnIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.columnCount) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2).fillInStackTrace();
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.autoIncrement[n2 - 1];
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.caseSensitive[n2 - 1];
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.searchable[n2 - 1];
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.currency[n2 - 1];
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.nullable[n2 - 1];
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.signed[n2 - 1];
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnDisplaySize[n2 - 1];
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnLabel[n2 - 1];
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnName[n2 - 1];
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.schemaName[n2 - 1];
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.precision[n2 - 1];
    }

    @Override
    public int getScale(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.scale[n2 - 1];
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.tableName[n2 - 1];
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.catalogName[n2 - 1];
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnType[n2 - 1];
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnTypeName[n2 - 1];
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.readOnly[n2 - 1];
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.writable[n2 - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.definatelyWritable[n2 - 1];
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnClassName[n2 - 1];
    }

    @Override
    public void setAutoIncrement(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.autoIncrement[n2 - 1] = bl;
    }

    @Override
    public void setCaseSensitive(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.caseSensitive[n2 - 1] = bl;
    }

    @Override
    public void setCatalogName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.catalogName[n2 - 1] = string;
    }

    @Override
    public void setColumnCount(int n2) throws SQLException {
        this.columnCount = n2;
    }

    @Override
    public void setColumnDisplaySize(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnDisplaySize[n2 - 1] = n3;
    }

    @Override
    public void setColumnLabel(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnLabel[n2 - 1] = string;
    }

    @Override
    public void setColumnName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnName[n2 - 1] = string;
    }

    @Override
    public void setColumnType(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnType[n2 - 1] = n3;
    }

    @Override
    public void setColumnTypeName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnTypeName[n2 - 1] = string;
    }

    @Override
    public void setCurrency(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.currency[n2 - 1] = bl;
    }

    @Override
    public void setNullable(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.nullable[n2 - 1] = n3;
    }

    @Override
    public void setPrecision(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.precision[n2 - 1] = n3;
    }

    @Override
    public void setScale(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.scale[n2 - 1] = n3;
    }

    @Override
    public void setSchemaName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.schemaName[n2 - 1] = string;
    }

    @Override
    public void setSearchable(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.searchable[n2 - 1] = bl;
    }

    @Override
    public void setSigned(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.signed[n2 - 1] = bl;
    }

    @Override
    public void setTableName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.tableName[n2 - 1] = string;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$43 = OracleRowSetMetaData.class.getDeclaredConstructor(ResultSetMetaData.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleRowSetMetaData.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleRowSetMetaData.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleRowSetMetaData.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleRowSetMetaData.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleRowSetMetaData.class.getDeclaredMethod("setTableName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleRowSetMetaData.class.getDeclaredMethod("setSigned", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleRowSetMetaData.class.getDeclaredMethod("setSearchable", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleRowSetMetaData.class.getDeclaredMethod("setSchemaName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleRowSetMetaData.class.getDeclaredMethod("setScale", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleRowSetMetaData.class.getDeclaredMethod("setPrecision", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleRowSetMetaData.class.getDeclaredMethod("setNullable", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleRowSetMetaData.class.getDeclaredMethod("setCurrency", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnTypeName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnType", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnLabel", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnDisplaySize", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleRowSetMetaData.class.getDeclaredMethod("setColumnCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleRowSetMetaData.class.getDeclaredMethod("setCatalogName", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleRowSetMetaData.class.getDeclaredMethod("setCaseSensitive", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleRowSetMetaData.class.getDeclaredMethod("setAutoIncrement", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnClassName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleRowSetMetaData.class.getDeclaredMethod("isDefinitelyWritable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleRowSetMetaData.class.getDeclaredMethod("isWritable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleRowSetMetaData.class.getDeclaredMethod("isReadOnly", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnTypeName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleRowSetMetaData.class.getDeclaredMethod("getCatalogName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleRowSetMetaData.class.getDeclaredMethod("getTableName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleRowSetMetaData.class.getDeclaredMethod("getScale", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleRowSetMetaData.class.getDeclaredMethod("getPrecision", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleRowSetMetaData.class.getDeclaredMethod("getSchemaName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnLabel", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnDisplaySize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleRowSetMetaData.class.getDeclaredMethod("isSigned", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleRowSetMetaData.class.getDeclaredMethod("isNullable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleRowSetMetaData.class.getDeclaredMethod("isCurrency", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleRowSetMetaData.class.getDeclaredMethod("isSearchable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleRowSetMetaData.class.getDeclaredMethod("isCaseSensitive", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleRowSetMetaData.class.getDeclaredMethod("isAutoIncrement", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleRowSetMetaData.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleRowSetMetaData.class.getDeclaredMethod("validateColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

