/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.workrequests;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import com.oracle.bmc.workrequests.WorkRequestAsync;
import com.oracle.bmc.workrequests.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.workrequests.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.workrequests.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.workrequests.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import com.oracle.bmc.workrequests.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.workrequests.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.workrequests.requests.ListWorkRequestsRequest;
import com.oracle.bmc.workrequests.responses.GetWorkRequestResponse;
import com.oracle.bmc.workrequests.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.workrequests.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.workrequests.responses.ListWorkRequestsResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkRequestAsyncClient
implements WorkRequestAsync {
    private static final Logger LOG = LoggerFactory.getLogger(WorkRequestAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WORKREQUEST").serviceEndpointPrefix("").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public WorkRequestAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public WorkRequestAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public WorkRequestAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public WorkRequestAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public WorkRequestAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public WorkRequestAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public WorkRequestAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        final ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        final ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return WorkRequestAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WorkRequestAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public WorkRequestAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new WorkRequestAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

