/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import com.oracle.bmc.objectstorage.transfer.internal.MultipartManifestImpl;
import java.beans.ConstructorProperties;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartTransferManager {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartTransferManager.class);
    private static final int MAX_RANDOM_SLEEP_BEFORE_UPLOAD_START_MS = 1000;
    private final SecureRandom random = new SecureRandom();
    private final ExecutorService executor;
    private final MultipartManifestImpl manifest;
    private final ObjectStorage client;
    private final List<Future<Void>> responses = new ArrayList<Future<Void>>();

    public synchronized void startTransfer(final UploadPartRequest request) {
        if (this.executor.isShutdown()) {
            throw new CancellationException("Executor used for transfers has been shutdown");
        }
        this.manifest.registerTransfer(request.getUploadPartNum());
        Future<Void> futureResponse = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Thread.sleep(MultipartTransferManager.this.random.nextInt(1000));
                    UploadPartResponse response = MultipartTransferManager.this.client.uploadPart(request);
                    MultipartTransferManager.this.manifest.registerSuccess(request.getUploadPartNum(), response);
                }
                catch (Exception e) {
                    LOG.error("Failed to upload part " + request.getUploadPartNum(), (Throwable)e);
                    MultipartTransferManager.this.manifest.registerFailure(request.getUploadPartNum());
                }
                return null;
            }
        });
        this.responses.add(futureResponse);
    }

    public void awaitCompletion() {
        for (Future<Void> f : this.responses) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                LOG.info("Thread interrupted while waiting for transfer completion", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                LOG.info("Execution exception while waiting for transfer completion", (Throwable)e);
            }
        }
    }

    public void abortAll() {
        for (Future<Void> f : this.responses) {
            f.cancel(true);
        }
    }

    @ConstructorProperties(value={"executor", "manifest", "client"})
    public MultipartTransferManager(ExecutorService executor, MultipartManifestImpl manifest, ObjectStorage client) {
        this.executor = executor;
        this.manifest = manifest;
        this.client = client;
    }
}

