/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import com.oracle.bmc.objectstorage.model.CommitMultipartUploadPartDetails;
import com.oracle.bmc.objectstorage.model.MultipartUploadPartSummary;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import com.oracle.bmc.objectstorage.transfer.MultipartManifest;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class MultipartManifestImpl
implements MultipartManifest {
    private final String uploadId;
    private final Map<Integer, PartAndStatus> parts = new HashMap<Integer, PartAndStatus>();
    private final AtomicInteger nextPartNumber = new AtomicInteger(1);
    private boolean isAborted = false;

    public synchronized void registerTransfer(int partNumber) {
        PartAndStatus partAndStatus = this.parts.get(partNumber);
        if (partAndStatus == null) {
            partAndStatus = new PartAndStatus();
            this.parts.put(partNumber, partAndStatus);
        }
    }

    public synchronized void registerSuccess(int partNumber, UploadPartResponse part) {
        PartAndStatus partAndStatus = this.parts.get(partNumber);
        partAndStatus.details = CommitMultipartUploadPartDetails.builder().etag(part.getETag()).partNum(Integer.valueOf(partNumber)).build();
        partAndStatus.complete = true;
        if (this.nextPartNumber.get() <= partNumber) {
            this.nextPartNumber.set(partNumber + 1);
        }
    }

    public synchronized void registerExisting(MultipartUploadPartSummary part) {
        PartAndStatus partAndStatus = new PartAndStatus(CommitMultipartUploadPartDetails.builder().etag(part.getEtag()).partNum(part.getPartNumber()).build(), true);
        this.parts.put(part.getPartNumber(), partAndStatus);
        if (this.nextPartNumber.get() <= part.getPartNumber()) {
            this.nextPartNumber.set(part.getPartNumber() + 1);
        }
    }

    public synchronized void registerFailure(int partNumber) {
        PartAndStatus partAndStatus = this.parts.get(partNumber);
        partAndStatus.complete = true;
    }

    @Override
    public synchronized boolean isUploadComplete() {
        for (PartAndStatus part : this.parts.values()) {
            if (part.complete) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isUploadSuccessful() {
        for (PartAndStatus part : this.parts.values()) {
            if (part.complete && part.details != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized List<CommitMultipartUploadPartDetails> listCompletedParts() {
        ArrayList<CommitMultipartUploadPartDetails> completedParts = new ArrayList<CommitMultipartUploadPartDetails>(this.parts.size());
        for (PartAndStatus part : this.parts.values()) {
            if (part.details == null) continue;
            completedParts.add(part.details);
        }
        return completedParts;
    }

    @Override
    public synchronized List<Integer> listFailedParts() {
        ArrayList<Integer> failedParts = new ArrayList<Integer>(this.parts.size());
        for (Map.Entry<Integer, PartAndStatus> part : this.parts.entrySet()) {
            if (!part.getValue().complete || part.getValue().details != null) continue;
            failedParts.add(part.getKey());
        }
        return failedParts;
    }

    @Override
    public synchronized List<Integer> listInProgressParts() {
        ArrayList<Integer> todoParts = new ArrayList<Integer>(this.parts.size());
        for (Map.Entry<Integer, PartAndStatus> part : this.parts.entrySet()) {
            if (part.getValue().complete) continue;
            todoParts.add(part.getKey());
        }
        return todoParts;
    }

    @Override
    public synchronized boolean isUploadAborted() {
        return this.isAborted;
    }

    public synchronized void markUploadAborted() {
        this.isAborted = true;
    }

    public Integer nextPartNumber() {
        return this.nextPartNumber.getAndIncrement();
    }

    @ConstructorProperties(value={"uploadId"})
    public MultipartManifestImpl(String uploadId) {
        this.uploadId = uploadId;
    }

    @Override
    public String getUploadId() {
        return this.uploadId;
    }

    private static final class PartAndStatus {
        private CommitMultipartUploadPartDetails details;
        private boolean complete = false;

        public PartAndStatus() {
        }

        @ConstructorProperties(value={"details", "complete"})
        public PartAndStatus(CommitMultipartUploadPartDetails details, boolean complete) {
            this.details = details;
            this.complete = complete;
        }
    }
}

