/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.generativeaiinference.model.ChatDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChatRequest
extends BmcRequest<ChatDetails> {
    private ChatDetails chatDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public ChatDetails getChatDetails() {
        return this.chatDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChatDetails getBody$() {
        return this.chatDetails;
    }

    public Builder toBuilder() {
        return new Builder().chatDetails(this.chatDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",chatDetails=").append(String.valueOf((Object)this.chatDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatRequest)) {
            return false;
        }
        ChatRequest other = (ChatRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.chatDetails, (Object)other.chatDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.chatDetails == null ? 43 : this.chatDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChatRequest, ChatDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private ChatDetails chatDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder chatDetails(ChatDetails chatDetails) {
            this.chatDetails = chatDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChatRequest o) {
            this.chatDetails(o.getChatDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChatRequest build() {
            ChatRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChatDetails body) {
            this.chatDetails(body);
            return this;
        }

        public ChatRequest buildWithoutInvocationCallback() {
            ChatRequest request = new ChatRequest();
            request.chatDetails = this.chatDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

