/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.ChatContent;
import com.oracle.bmc.generativeaiinference.model.Message;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="role")
@JsonFilter(value="explicitlySetFilter")
public final class ToolMessage
extends Message {
    @JsonProperty(value="toolCallId")
    private final String toolCallId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ToolMessage(List<ChatContent> content, String toolCallId) {
        super(content);
        this.toolCallId = toolCallId;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ToolMessage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", toolCallId=").append(String.valueOf(this.toolCallId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ToolMessage)) {
            return false;
        }
        ToolMessage other = (ToolMessage)((Object)o);
        return Objects.equals(this.toolCallId, other.toolCallId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.toolCallId == null ? 43 : this.toolCallId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="content")
        private List<ChatContent> content;
        @JsonProperty(value="toolCallId")
        private String toolCallId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder content(List<ChatContent> content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            this.__explicitlySet__.add("toolCallId");
            return this;
        }

        public ToolMessage build() {
            ToolMessage model = new ToolMessage(this.content, this.toolCallId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ToolMessage model) {
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("toolCallId")) {
                this.toolCallId(model.getToolCallId());
            }
            return this;
        }
    }
}

