/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.Document;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DocumentRank
extends ExplicitlySetBmcModel {
    @JsonProperty(value="index")
    private final Integer index;
    @JsonProperty(value="relevanceScore")
    private final Double relevanceScore;
    @JsonProperty(value="document")
    private final Document document;

    @Deprecated
    @ConstructorProperties(value={"index", "relevanceScore", "document"})
    public DocumentRank(Integer index, Double relevanceScore, Document document) {
        this.index = index;
        this.relevanceScore = relevanceScore;
        this.document = document;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getIndex() {
        return this.index;
    }

    public Double getRelevanceScore() {
        return this.relevanceScore;
    }

    public Document getDocument() {
        return this.document;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DocumentRank(");
        sb.append("super=").append(super.toString());
        sb.append("index=").append(String.valueOf(this.index));
        sb.append(", relevanceScore=").append(String.valueOf(this.relevanceScore));
        sb.append(", document=").append(String.valueOf((Object)this.document));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentRank)) {
            return false;
        }
        DocumentRank other = (DocumentRank)((Object)o);
        return Objects.equals(this.index, other.index) && Objects.equals(this.relevanceScore, other.relevanceScore) && Objects.equals((Object)this.document, (Object)other.document) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.index == null ? 43 : this.index.hashCode());
        result = result * 59 + (this.relevanceScore == null ? 43 : this.relevanceScore.hashCode());
        result = result * 59 + (this.document == null ? 43 : this.document.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="index")
        private Integer index;
        @JsonProperty(value="relevanceScore")
        private Double relevanceScore;
        @JsonProperty(value="document")
        private Document document;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder index(Integer index) {
            this.index = index;
            this.__explicitlySet__.add("index");
            return this;
        }

        public Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            this.__explicitlySet__.add("relevanceScore");
            return this;
        }

        public Builder document(Document document) {
            this.document = document;
            this.__explicitlySet__.add("document");
            return this;
        }

        public DocumentRank build() {
            DocumentRank model = new DocumentRank(this.index, this.relevanceScore, this.document);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DocumentRank model) {
            if (model.wasPropertyExplicitlySet("index")) {
                this.index(model.getIndex());
            }
            if (model.wasPropertyExplicitlySet("relevanceScore")) {
                this.relevanceScore(model.getRelevanceScore());
            }
            if (model.wasPropertyExplicitlySet("document")) {
                this.document(model.getDocument());
            }
            return this;
        }
    }
}

