/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.GeneratedText;
import com.oracle.bmc.generativeaiinference.model.LlmInferenceResponse;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="runtimeType")
@JsonFilter(value="explicitlySetFilter")
public final class CohereLlmInferenceResponse
extends LlmInferenceResponse {
    @JsonProperty(value="generatedTexts")
    private final List<GeneratedText> generatedTexts;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="prompt")
    private final String prompt;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CohereLlmInferenceResponse(List<GeneratedText> generatedTexts, Date timeCreated, String prompt) {
        this.generatedTexts = generatedTexts;
        this.timeCreated = timeCreated;
        this.prompt = prompt;
    }

    public List<GeneratedText> getGeneratedTexts() {
        return this.generatedTexts;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CohereLlmInferenceResponse(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", generatedTexts=").append(String.valueOf(this.generatedTexts));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", prompt=").append(String.valueOf(this.prompt));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CohereLlmInferenceResponse)) {
            return false;
        }
        CohereLlmInferenceResponse other = (CohereLlmInferenceResponse)((Object)o);
        return Objects.equals(this.generatedTexts, other.generatedTexts) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.prompt, other.prompt) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.generatedTexts == null ? 43 : this.generatedTexts.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.prompt == null ? 43 : this.prompt.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="generatedTexts")
        private List<GeneratedText> generatedTexts;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="prompt")
        private String prompt;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder generatedTexts(List<GeneratedText> generatedTexts) {
            this.generatedTexts = generatedTexts;
            this.__explicitlySet__.add("generatedTexts");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            this.__explicitlySet__.add("prompt");
            return this;
        }

        public CohereLlmInferenceResponse build() {
            CohereLlmInferenceResponse model = new CohereLlmInferenceResponse(this.generatedTexts, this.timeCreated, this.prompt);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CohereLlmInferenceResponse model) {
            if (model.wasPropertyExplicitlySet("generatedTexts")) {
                this.generatedTexts(model.getGeneratedTexts());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("prompt")) {
                this.prompt(model.getPrompt());
            }
            return this;
        }
    }
}

