/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Citation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="start")
    private final Integer start;
    @JsonProperty(value="end")
    private final Integer end;
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="documentIds")
    private final List<String> documentIds;

    @Deprecated
    @ConstructorProperties(value={"start", "end", "text", "documentIds"})
    public Citation(Integer start, Integer end, String text, List<String> documentIds) {
        this.start = start;
        this.end = end;
        this.text = text;
        this.documentIds = documentIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Citation(");
        sb.append("super=").append(super.toString());
        sb.append("start=").append(String.valueOf(this.start));
        sb.append(", end=").append(String.valueOf(this.end));
        sb.append(", text=").append(String.valueOf(this.text));
        sb.append(", documentIds=").append(String.valueOf(this.documentIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Citation)) {
            return false;
        }
        Citation other = (Citation)((Object)o);
        return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.text, other.text) && Objects.equals(this.documentIds, other.documentIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.start == null ? 43 : this.start.hashCode());
        result = result * 59 + (this.end == null ? 43 : this.end.hashCode());
        result = result * 59 + (this.text == null ? 43 : this.text.hashCode());
        result = result * 59 + (this.documentIds == null ? 43 : this.documentIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="start")
        private Integer start;
        @JsonProperty(value="end")
        private Integer end;
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="documentIds")
        private List<String> documentIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder start(Integer start) {
            this.start = start;
            this.__explicitlySet__.add("start");
            return this;
        }

        public Builder end(Integer end) {
            this.end = end;
            this.__explicitlySet__.add("end");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.__explicitlySet__.add("text");
            return this;
        }

        public Builder documentIds(List<String> documentIds) {
            this.documentIds = documentIds;
            this.__explicitlySet__.add("documentIds");
            return this;
        }

        public Citation build() {
            Citation model = new Citation(this.start, this.end, this.text, this.documentIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Citation model) {
            if (model.wasPropertyExplicitlySet("start")) {
                this.start(model.getStart());
            }
            if (model.wasPropertyExplicitlySet("end")) {
                this.end(model.getEnd());
            }
            if (model.wasPropertyExplicitlySet("text")) {
                this.text(model.getText());
            }
            if (model.wasPropertyExplicitlySet("documentIds")) {
                this.documentIds(model.getDocumentIds());
            }
            return this;
        }
    }
}

