/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.responses;

import com.oracle.bmc.datacatalog.model.RecommendationCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecommendationsResponse
extends BmcResponse {
    private String opcRequestId;
    private RecommendationCollection recommendationCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RecommendationCollection getRecommendationCollection() {
        return this.recommendationCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "recommendationCollection"})
    private RecommendationsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, RecommendationCollection recommendationCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.recommendationCollection = recommendationCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",recommendationCollection=").append(String.valueOf((Object)this.recommendationCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecommendationsResponse)) {
            return false;
        }
        RecommendationsResponse other = (RecommendationsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.recommendationCollection, (Object)other.recommendationCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.recommendationCollection == null ? 43 : this.recommendationCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<RecommendationsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private RecommendationCollection recommendationCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder recommendationCollection(RecommendationCollection recommendationCollection) {
            this.recommendationCollection = recommendationCollection;
            return this;
        }

        public Builder copy(RecommendationsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.recommendationCollection(o.getRecommendationCollection());
            return this;
        }

        public RecommendationsResponse build() {
            return new RecommendationsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.recommendationCollection);
        }
    }
}

