/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdatePatternDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePatternRequest
extends BmcRequest<UpdatePatternDetails> {
    private String catalogId;
    private String patternKey;
    private UpdatePatternDetails updatePatternDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getPatternKey() {
        return this.patternKey;
    }

    public UpdatePatternDetails getUpdatePatternDetails() {
        return this.updatePatternDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdatePatternDetails getBody$() {
        return this.updatePatternDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).patternKey(this.patternKey).updatePatternDetails(this.updatePatternDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",patternKey=").append(String.valueOf(this.patternKey));
        sb.append(",updatePatternDetails=").append(String.valueOf((Object)this.updatePatternDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePatternRequest)) {
            return false;
        }
        UpdatePatternRequest other = (UpdatePatternRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.patternKey, other.patternKey) && Objects.equals((Object)this.updatePatternDetails, (Object)other.updatePatternDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.patternKey == null ? 43 : this.patternKey.hashCode());
        result = result * 59 + (this.updatePatternDetails == null ? 43 : this.updatePatternDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePatternRequest, UpdatePatternDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String patternKey = null;
        private UpdatePatternDetails updatePatternDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder patternKey(String patternKey) {
            this.patternKey = patternKey;
            return this;
        }

        public Builder updatePatternDetails(UpdatePatternDetails updatePatternDetails) {
            this.updatePatternDetails = updatePatternDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePatternRequest o) {
            this.catalogId(o.getCatalogId());
            this.patternKey(o.getPatternKey());
            this.updatePatternDetails(o.getUpdatePatternDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePatternRequest build() {
            UpdatePatternRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePatternDetails body) {
            this.updatePatternDetails(body);
            return this;
        }

        public UpdatePatternRequest buildWithoutInvocationCallback() {
            UpdatePatternRequest request = new UpdatePatternRequest();
            request.catalogId = this.catalogId;
            request.patternKey = this.patternKey;
            request.updatePatternDetails = this.updatePatternDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

