/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdateGlossaryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateGlossaryRequest
extends BmcRequest<UpdateGlossaryDetails> {
    private String catalogId;
    private String glossaryKey;
    private UpdateGlossaryDetails updateGlossaryDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public UpdateGlossaryDetails getUpdateGlossaryDetails() {
        return this.updateGlossaryDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateGlossaryDetails getBody$() {
        return this.updateGlossaryDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).glossaryKey(this.glossaryKey).updateGlossaryDetails(this.updateGlossaryDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",glossaryKey=").append(String.valueOf(this.glossaryKey));
        sb.append(",updateGlossaryDetails=").append(String.valueOf((Object)this.updateGlossaryDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateGlossaryRequest)) {
            return false;
        }
        UpdateGlossaryRequest other = (UpdateGlossaryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.glossaryKey, other.glossaryKey) && Objects.equals((Object)this.updateGlossaryDetails, (Object)other.updateGlossaryDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.glossaryKey == null ? 43 : this.glossaryKey.hashCode());
        result = result * 59 + (this.updateGlossaryDetails == null ? 43 : this.updateGlossaryDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateGlossaryRequest, UpdateGlossaryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String glossaryKey = null;
        private UpdateGlossaryDetails updateGlossaryDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder updateGlossaryDetails(UpdateGlossaryDetails updateGlossaryDetails) {
            this.updateGlossaryDetails = updateGlossaryDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateGlossaryRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.updateGlossaryDetails(o.getUpdateGlossaryDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateGlossaryRequest build() {
            UpdateGlossaryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateGlossaryDetails body) {
            this.updateGlossaryDetails(body);
            return this;
        }

        public UpdateGlossaryRequest buildWithoutInvocationCallback() {
            UpdateGlossaryRequest request = new UpdateGlossaryRequest();
            request.catalogId = this.catalogId;
            request.glossaryKey = this.glossaryKey;
            request.updateGlossaryDetails = this.updateGlossaryDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

