/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SuggestMatchesRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String inputText;
    private String timeout;
    private Integer limit;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getInputText() {
        return this.inputText;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).inputText(this.inputText).timeout(this.timeout).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",inputText=").append(String.valueOf(this.inputText));
        sb.append(",timeout=").append(String.valueOf(this.timeout));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SuggestMatchesRequest)) {
            return false;
        }
        SuggestMatchesRequest other = (SuggestMatchesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.inputText, other.inputText) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.inputText == null ? 43 : this.inputText.hashCode());
        result = result * 59 + (this.timeout == null ? 43 : this.timeout.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SuggestMatchesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String inputText = null;
        private String timeout = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public Builder timeout(String timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SuggestMatchesRequest o) {
            this.catalogId(o.getCatalogId());
            this.inputText(o.getInputText());
            this.timeout(o.getTimeout());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SuggestMatchesRequest build() {
            SuggestMatchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SuggestMatchesRequest buildWithoutInvocationCallback() {
            SuggestMatchesRequest request = new SuggestMatchesRequest();
            request.catalogId = this.catalogId;
            request.inputText = this.inputText;
            request.timeout = this.timeout;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

