/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.datacatalog.model.RecommendationResourceType;
import com.oracle.bmc.datacatalog.model.RecommendationStatus;
import com.oracle.bmc.datacatalog.model.RecommendationType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class RecommendationsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private List<RecommendationType> recommendationType;
    private String sourceObjectKey;
    private RecommendationResourceType sourceObjectType;
    private RecommendationStatus recommendationStatus;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public List<RecommendationType> getRecommendationType() {
        return this.recommendationType;
    }

    public String getSourceObjectKey() {
        return this.sourceObjectKey;
    }

    public RecommendationResourceType getSourceObjectType() {
        return this.sourceObjectType;
    }

    public RecommendationStatus getRecommendationStatus() {
        return this.recommendationStatus;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).recommendationType(this.recommendationType).sourceObjectKey(this.sourceObjectKey).sourceObjectType(this.sourceObjectType).recommendationStatus(this.recommendationStatus).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",recommendationType=").append(String.valueOf(this.recommendationType));
        sb.append(",sourceObjectKey=").append(String.valueOf(this.sourceObjectKey));
        sb.append(",sourceObjectType=").append(String.valueOf((Object)this.sourceObjectType));
        sb.append(",recommendationStatus=").append(String.valueOf((Object)this.recommendationStatus));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecommendationsRequest)) {
            return false;
        }
        RecommendationsRequest other = (RecommendationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.recommendationType, other.recommendationType) && Objects.equals(this.sourceObjectKey, other.sourceObjectKey) && Objects.equals((Object)this.sourceObjectType, (Object)other.sourceObjectType) && Objects.equals((Object)this.recommendationStatus, (Object)other.recommendationStatus) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.recommendationType == null ? 43 : this.recommendationType.hashCode());
        result = result * 59 + (this.sourceObjectKey == null ? 43 : this.sourceObjectKey.hashCode());
        result = result * 59 + (this.sourceObjectType == null ? 43 : this.sourceObjectType.hashCode());
        result = result * 59 + (this.recommendationStatus == null ? 43 : this.recommendationStatus.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RecommendationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private List<RecommendationType> recommendationType = null;
        private String sourceObjectKey = null;
        private RecommendationResourceType sourceObjectType = null;
        private RecommendationStatus recommendationStatus = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder recommendationType(List<RecommendationType> recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        public Builder recommendationType(RecommendationType singularValue) {
            return this.recommendationType(Arrays.asList(singularValue));
        }

        public Builder sourceObjectKey(String sourceObjectKey) {
            this.sourceObjectKey = sourceObjectKey;
            return this;
        }

        public Builder sourceObjectType(RecommendationResourceType sourceObjectType) {
            this.sourceObjectType = sourceObjectType;
            return this;
        }

        public Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RecommendationsRequest o) {
            this.catalogId(o.getCatalogId());
            this.recommendationType(o.getRecommendationType());
            this.sourceObjectKey(o.getSourceObjectKey());
            this.sourceObjectType(o.getSourceObjectType());
            this.recommendationStatus(o.getRecommendationStatus());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RecommendationsRequest build() {
            RecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RecommendationsRequest buildWithoutInvocationCallback() {
            RecommendationsRequest request = new RecommendationsRequest();
            request.catalogId = this.catalogId;
            request.recommendationType = this.recommendationType;
            request.sourceObjectKey = this.sourceObjectKey;
            request.sourceObjectType = this.sourceObjectType;
            request.recommendationStatus = this.recommendationStatus;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

