/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ProcessRecommendationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ProcessRecommendationRequest
extends BmcRequest<ProcessRecommendationDetails> {
    private String catalogId;
    private ProcessRecommendationDetails processRecommendationDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public ProcessRecommendationDetails getProcessRecommendationDetails() {
        return this.processRecommendationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ProcessRecommendationDetails getBody$() {
        return this.processRecommendationDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).processRecommendationDetails(this.processRecommendationDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",processRecommendationDetails=").append(String.valueOf((Object)this.processRecommendationDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessRecommendationRequest)) {
            return false;
        }
        ProcessRecommendationRequest other = (ProcessRecommendationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals((Object)this.processRecommendationDetails, (Object)other.processRecommendationDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.processRecommendationDetails == null ? 43 : this.processRecommendationDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ProcessRecommendationRequest, ProcessRecommendationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private ProcessRecommendationDetails processRecommendationDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder processRecommendationDetails(ProcessRecommendationDetails processRecommendationDetails) {
            this.processRecommendationDetails = processRecommendationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ProcessRecommendationRequest o) {
            this.catalogId(o.getCatalogId());
            this.processRecommendationDetails(o.getProcessRecommendationDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ProcessRecommendationRequest build() {
            ProcessRecommendationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ProcessRecommendationDetails body) {
            this.processRecommendationDetails(body);
            return this;
        }

        public ProcessRecommendationRequest buildWithoutInvocationCallback() {
            ProcessRecommendationRequest request = new ProcessRecommendationRequest();
            request.catalogId = this.catalogId;
            request.processRecommendationDetails = this.processRecommendationDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

