/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListTypesRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String name;
    private LifecycleState lifecycleState;
    private String isInternal;
    private String isTag;
    private String isApproved;
    private String externalTypeName;
    private String typeCategory;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getName() {
        return this.name;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getIsInternal() {
        return this.isInternal;
    }

    public String getIsTag() {
        return this.isTag;
    }

    public String getIsApproved() {
        return this.isApproved;
    }

    public String getExternalTypeName() {
        return this.externalTypeName;
    }

    public String getTypeCategory() {
        return this.typeCategory;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).name(this.name).lifecycleState(this.lifecycleState).isInternal(this.isInternal).isTag(this.isTag).isApproved(this.isApproved).externalTypeName(this.externalTypeName).typeCategory(this.typeCategory).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",isInternal=").append(String.valueOf(this.isInternal));
        sb.append(",isTag=").append(String.valueOf(this.isTag));
        sb.append(",isApproved=").append(String.valueOf(this.isApproved));
        sb.append(",externalTypeName=").append(String.valueOf(this.externalTypeName));
        sb.append(",typeCategory=").append(String.valueOf(this.typeCategory));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTypesRequest)) {
            return false;
        }
        ListTypesRequest other = (ListTypesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.isInternal, other.isInternal) && Objects.equals(this.isTag, other.isTag) && Objects.equals(this.isApproved, other.isApproved) && Objects.equals(this.externalTypeName, other.externalTypeName) && Objects.equals(this.typeCategory, other.typeCategory) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.isInternal == null ? 43 : this.isInternal.hashCode());
        result = result * 59 + (this.isTag == null ? 43 : this.isTag.hashCode());
        result = result * 59 + (this.isApproved == null ? 43 : this.isApproved.hashCode());
        result = result * 59 + (this.externalTypeName == null ? 43 : this.externalTypeName.hashCode());
        result = result * 59 + (this.typeCategory == null ? 43 : this.typeCategory.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTypesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String name = null;
        private LifecycleState lifecycleState = null;
        private String isInternal = null;
        private String isTag = null;
        private String isApproved = null;
        private String externalTypeName = null;
        private String typeCategory = null;
        private List<Fields> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder isInternal(String isInternal) {
            this.isInternal = isInternal;
            return this;
        }

        public Builder isTag(String isTag) {
            this.isTag = isTag;
            return this;
        }

        public Builder isApproved(String isApproved) {
            this.isApproved = isApproved;
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            return this;
        }

        public Builder typeCategory(String typeCategory) {
            this.typeCategory = typeCategory;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTypesRequest o) {
            this.catalogId(o.getCatalogId());
            this.name(o.getName());
            this.lifecycleState(o.getLifecycleState());
            this.isInternal(o.getIsInternal());
            this.isTag(o.getIsTag());
            this.isApproved(o.getIsApproved());
            this.externalTypeName(o.getExternalTypeName());
            this.typeCategory(o.getTypeCategory());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTypesRequest build() {
            ListTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTypesRequest buildWithoutInvocationCallback() {
            ListTypesRequest request = new ListTypesRequest();
            request.catalogId = this.catalogId;
            request.name = this.name;
            request.lifecycleState = this.lifecycleState;
            request.isInternal = this.isInternal;
            request.isTag = this.isTag;
            request.isApproved = this.isApproved;
            request.externalTypeName = this.externalTypeName;
            request.typeCategory = this.typeCategory;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        Description("description"),
        Name("name"),
        CatalogId("catalogId"),
        LifecycleState("lifecycleState"),
        TypeCategory("typeCategory"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

