/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.datacatalog.model.TermWorkflowStatus;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListTermsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String glossaryKey;
    private String displayName;
    private String displayNameContains;
    private LifecycleState lifecycleState;
    private String parentTermKey;
    private Boolean isAllowedToHaveChildTerms;
    private TermWorkflowStatus workflowStatus;
    private String path;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getParentTermKey() {
        return this.parentTermKey;
    }

    public Boolean getIsAllowedToHaveChildTerms() {
        return this.isAllowedToHaveChildTerms;
    }

    public TermWorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }

    public String getPath() {
        return this.path;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).glossaryKey(this.glossaryKey).displayName(this.displayName).displayNameContains(this.displayNameContains).lifecycleState(this.lifecycleState).parentTermKey(this.parentTermKey).isAllowedToHaveChildTerms(this.isAllowedToHaveChildTerms).workflowStatus(this.workflowStatus).path(this.path).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",glossaryKey=").append(String.valueOf(this.glossaryKey));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",parentTermKey=").append(String.valueOf(this.parentTermKey));
        sb.append(",isAllowedToHaveChildTerms=").append(String.valueOf(this.isAllowedToHaveChildTerms));
        sb.append(",workflowStatus=").append(String.valueOf((Object)this.workflowStatus));
        sb.append(",path=").append(String.valueOf(this.path));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTermsRequest)) {
            return false;
        }
        ListTermsRequest other = (ListTermsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.glossaryKey, other.glossaryKey) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.parentTermKey, other.parentTermKey) && Objects.equals(this.isAllowedToHaveChildTerms, other.isAllowedToHaveChildTerms) && Objects.equals((Object)this.workflowStatus, (Object)other.workflowStatus) && Objects.equals(this.path, other.path) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.glossaryKey == null ? 43 : this.glossaryKey.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.parentTermKey == null ? 43 : this.parentTermKey.hashCode());
        result = result * 59 + (this.isAllowedToHaveChildTerms == null ? 43 : this.isAllowedToHaveChildTerms.hashCode());
        result = result * 59 + (this.workflowStatus == null ? 43 : this.workflowStatus.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTermsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String glossaryKey = null;
        private String displayName = null;
        private String displayNameContains = null;
        private LifecycleState lifecycleState = null;
        private String parentTermKey = null;
        private Boolean isAllowedToHaveChildTerms = null;
        private TermWorkflowStatus workflowStatus = null;
        private String path = null;
        private List<Fields> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder parentTermKey(String parentTermKey) {
            this.parentTermKey = parentTermKey;
            return this;
        }

        public Builder isAllowedToHaveChildTerms(Boolean isAllowedToHaveChildTerms) {
            this.isAllowedToHaveChildTerms = isAllowedToHaveChildTerms;
            return this;
        }

        public Builder workflowStatus(TermWorkflowStatus workflowStatus) {
            this.workflowStatus = workflowStatus;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTermsRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.lifecycleState(o.getLifecycleState());
            this.parentTermKey(o.getParentTermKey());
            this.isAllowedToHaveChildTerms(o.getIsAllowedToHaveChildTerms());
            this.workflowStatus(o.getWorkflowStatus());
            this.path(o.getPath());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTermsRequest build() {
            ListTermsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTermsRequest buildWithoutInvocationCallback() {
            ListTermsRequest request = new ListTermsRequest();
            request.catalogId = this.catalogId;
            request.glossaryKey = this.glossaryKey;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.lifecycleState = this.lifecycleState;
            request.parentTermKey = this.parentTermKey;
            request.isAllowedToHaveChildTerms = this.isAllowedToHaveChildTerms;
            request.workflowStatus = this.workflowStatus;
            request.path = this.path;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        GlossaryKey("glossaryKey"),
        ParentTermKey("parentTermKey"),
        IsAllowedToHaveChildTerms("isAllowedToHaveChildTerms"),
        Path("path"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        WorkflowStatus("workflowStatus"),
        AssociatedObjectCount("associatedObjectCount"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

