/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.HarvestStatus;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListFoldersRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String dataAssetKey;
    private String displayName;
    private String businessName;
    private String displayOrBusinessNameContains;
    private String displayNameContains;
    private LifecycleState lifecycleState;
    private String parentFolderKey;
    private String path;
    private String externalKey;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private HarvestStatus harvestStatus;
    private String lastJobKey;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getDisplayOrBusinessNameContains() {
        return this.displayOrBusinessNameContains;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getParentFolderKey() {
        return this.parentFolderKey;
    }

    public String getPath() {
        return this.path;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public HarvestStatus getHarvestStatus() {
        return this.harvestStatus;
    }

    public String getLastJobKey() {
        return this.lastJobKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).dataAssetKey(this.dataAssetKey).displayName(this.displayName).businessName(this.businessName).displayOrBusinessNameContains(this.displayOrBusinessNameContains).displayNameContains(this.displayNameContains).lifecycleState(this.lifecycleState).parentFolderKey(this.parentFolderKey).path(this.path).externalKey(this.externalKey).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).createdById(this.createdById).updatedById(this.updatedById).harvestStatus(this.harvestStatus).lastJobKey(this.lastJobKey).fields(this.fields).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",businessName=").append(String.valueOf(this.businessName));
        sb.append(",displayOrBusinessNameContains=").append(String.valueOf(this.displayOrBusinessNameContains));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",parentFolderKey=").append(String.valueOf(this.parentFolderKey));
        sb.append(",path=").append(String.valueOf(this.path));
        sb.append(",externalKey=").append(String.valueOf(this.externalKey));
        sb.append(",timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(",timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(",createdById=").append(String.valueOf(this.createdById));
        sb.append(",updatedById=").append(String.valueOf(this.updatedById));
        sb.append(",harvestStatus=").append(String.valueOf((Object)this.harvestStatus));
        sb.append(",lastJobKey=").append(String.valueOf(this.lastJobKey));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListFoldersRequest)) {
            return false;
        }
        ListFoldersRequest other = (ListFoldersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.businessName, other.businessName) && Objects.equals(this.displayOrBusinessNameContains, other.displayOrBusinessNameContains) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.parentFolderKey, other.parentFolderKey) && Objects.equals(this.path, other.path) && Objects.equals(this.externalKey, other.externalKey) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && Objects.equals((Object)this.harvestStatus, (Object)other.harvestStatus) && Objects.equals(this.lastJobKey, other.lastJobKey) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.businessName == null ? 43 : this.businessName.hashCode());
        result = result * 59 + (this.displayOrBusinessNameContains == null ? 43 : this.displayOrBusinessNameContains.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.parentFolderKey == null ? 43 : this.parentFolderKey.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.externalKey == null ? 43 : this.externalKey.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + (this.harvestStatus == null ? 43 : this.harvestStatus.hashCode());
        result = result * 59 + (this.lastJobKey == null ? 43 : this.lastJobKey.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListFoldersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String dataAssetKey = null;
        private String displayName = null;
        private String businessName = null;
        private String displayOrBusinessNameContains = null;
        private String displayNameContains = null;
        private LifecycleState lifecycleState = null;
        private String parentFolderKey = null;
        private String path = null;
        private String externalKey = null;
        private Date timeCreated = null;
        private Date timeUpdated = null;
        private String createdById = null;
        private String updatedById = null;
        private HarvestStatus harvestStatus = null;
        private String lastJobKey = null;
        private List<Fields> fields = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public Builder displayOrBusinessNameContains(String displayOrBusinessNameContains) {
            this.displayOrBusinessNameContains = displayOrBusinessNameContains;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder parentFolderKey(String parentFolderKey) {
            this.parentFolderKey = parentFolderKey;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder harvestStatus(HarvestStatus harvestStatus) {
            this.harvestStatus = harvestStatus;
            return this;
        }

        public Builder lastJobKey(String lastJobKey) {
            this.lastJobKey = lastJobKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFoldersRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.displayName(o.getDisplayName());
            this.businessName(o.getBusinessName());
            this.displayOrBusinessNameContains(o.getDisplayOrBusinessNameContains());
            this.displayNameContains(o.getDisplayNameContains());
            this.lifecycleState(o.getLifecycleState());
            this.parentFolderKey(o.getParentFolderKey());
            this.path(o.getPath());
            this.externalKey(o.getExternalKey());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.harvestStatus(o.getHarvestStatus());
            this.lastJobKey(o.getLastJobKey());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFoldersRequest build() {
            ListFoldersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListFoldersRequest buildWithoutInvocationCallback() {
            ListFoldersRequest request = new ListFoldersRequest();
            request.catalogId = this.catalogId;
            request.dataAssetKey = this.dataAssetKey;
            request.displayName = this.displayName;
            request.businessName = this.businessName;
            request.displayOrBusinessNameContains = this.displayOrBusinessNameContains;
            request.displayNameContains = this.displayNameContains;
            request.lifecycleState = this.lifecycleState;
            request.parentFolderKey = this.parentFolderKey;
            request.path = this.path;
            request.externalKey = this.externalKey;
            request.timeCreated = this.timeCreated;
            request.timeUpdated = this.timeUpdated;
            request.createdById = this.createdById;
            request.updatedById = this.updatedById;
            request.harvestStatus = this.harvestStatus;
            request.lastJobKey = this.lastJobKey;
            request.fields = this.fields;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        ParentFolderKey("parentFolderKey"),
        Path("path"),
        DataAssetKey("dataAssetKey"),
        ExternalKey("externalKey"),
        TimeExternal("timeExternal"),
        TimeCreated("timeCreated"),
        LifecycleState("lifecycleState"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

