/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.CustomPropertyDataType;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListCustomPropertiesRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String namespaceId;
    private String displayName;
    private String displayNameContains;
    private List<CustomPropertyDataType> dataTypes;
    private List<TypeName> typeName;
    private LifecycleState lifecycleState;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private List<Fields> fields;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public List<CustomPropertyDataType> getDataTypes() {
        return this.dataTypes;
    }

    public List<TypeName> getTypeName() {
        return this.typeName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).namespaceId(this.namespaceId).displayName(this.displayName).displayNameContains(this.displayNameContains).dataTypes(this.dataTypes).typeName(this.typeName).lifecycleState(this.lifecycleState).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).createdById(this.createdById).updatedById(this.updatedById).fields(this.fields).sortOrder(this.sortOrder).sortBy(this.sortBy).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",namespaceId=").append(String.valueOf(this.namespaceId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",dataTypes=").append(String.valueOf(this.dataTypes));
        sb.append(",typeName=").append(String.valueOf(this.typeName));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(",timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(",createdById=").append(String.valueOf(this.createdById));
        sb.append(",updatedById=").append(String.valueOf(this.updatedById));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListCustomPropertiesRequest)) {
            return false;
        }
        ListCustomPropertiesRequest other = (ListCustomPropertiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.namespaceId, other.namespaceId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.dataTypes, other.dataTypes) && Objects.equals(this.typeName, other.typeName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.namespaceId == null ? 43 : this.namespaceId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.dataTypes == null ? 43 : this.dataTypes.hashCode());
        result = result * 59 + (this.typeName == null ? 43 : this.typeName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListCustomPropertiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String namespaceId = null;
        private String displayName = null;
        private String displayNameContains = null;
        private List<CustomPropertyDataType> dataTypes = null;
        private List<TypeName> typeName = null;
        private LifecycleState lifecycleState = null;
        private Date timeCreated = null;
        private Date timeUpdated = null;
        private String createdById = null;
        private String updatedById = null;
        private List<Fields> fields = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder dataTypes(List<CustomPropertyDataType> dataTypes) {
            this.dataTypes = dataTypes;
            return this;
        }

        public Builder dataTypes(CustomPropertyDataType singularValue) {
            return this.dataTypes(Arrays.asList(singularValue));
        }

        public Builder typeName(List<TypeName> typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder typeName(TypeName singularValue) {
            return this.typeName(Arrays.asList(singularValue));
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListCustomPropertiesRequest o) {
            this.catalogId(o.getCatalogId());
            this.namespaceId(o.getNamespaceId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.dataTypes(o.getDataTypes());
            this.typeName(o.getTypeName());
            this.lifecycleState(o.getLifecycleState());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.fields(o.getFields());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListCustomPropertiesRequest build() {
            ListCustomPropertiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListCustomPropertiesRequest buildWithoutInvocationCallback() {
            ListCustomPropertiesRequest request = new ListCustomPropertiesRequest();
            request.catalogId = this.catalogId;
            request.namespaceId = this.namespaceId;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.dataTypes = this.dataTypes;
            request.typeName = this.typeName;
            request.lifecycleState = this.lifecycleState;
            request.timeCreated = this.timeCreated;
            request.timeUpdated = this.timeUpdated;
            request.createdById = this.createdById;
            request.updatedById = this.updatedById;
            request.fields = this.fields;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Displayname("DISPLAYNAME"),
        Usagecount("USAGECOUNT");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        DataType("dataType"),
        NamespaceName("namespaceName"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TypeName implements BmcEnum
    {
        DataAsset("DATA_ASSET"),
        AutonomousDataWarehouse("AUTONOMOUS_DATA_WAREHOUSE"),
        Hive("HIVE"),
        Kafka("KAFKA"),
        Mysql("MYSQL"),
        OracleObjectStorage("ORACLE_OBJECT_STORAGE"),
        AutonomousTransactionProcessing("AUTONOMOUS_TRANSACTION_PROCESSING"),
        Oracle("ORACLE"),
        Postgresql("POSTGRESQL"),
        MicrosoftAzureSqlDatabase("MICROSOFT_AZURE_SQL_DATABASE"),
        MicrosoftSqlServer("MICROSOFT_SQL_SERVER"),
        IbmDb2("IBM_DB2"),
        DataEntity("DATA_ENTITY"),
        LogicalEntity("LOGICAL_ENTITY"),
        Table("TABLE"),
        View("VIEW"),
        Attribute("ATTRIBUTE"),
        Folder("FOLDER"),
        OracleAnalyticsSubjectAreaColumn("ORACLE_ANALYTICS_SUBJECT_AREA_COLUMN"),
        OracleAnalyticsLogicalColumn("ORACLE_ANALYTICS_LOGICAL_COLUMN"),
        OracleAnalyticsPhysicalColumn("ORACLE_ANALYTICS_PHYSICAL_COLUMN"),
        OracleAnalyticsAnalysisColumn("ORACLE_ANALYTICS_ANALYSIS_COLUMN"),
        OracleAnalyticsServer("ORACLE_ANALYTICS_SERVER"),
        OracleAnalyticsCloud("ORACLE_ANALYTICS_CLOUD"),
        OracleAnalyticsSubjectArea("ORACLE_ANALYTICS_SUBJECT_AREA"),
        OracleAnalyticsDashboard("ORACLE_ANALYTICS_DASHBOARD"),
        OracleAnalyticsBusinessModel("ORACLE_ANALYTICS_BUSINESS_MODEL"),
        OracleAnalyticsPhysicalDatabase("ORACLE_ANALYTICS_PHYSICAL_DATABASE"),
        OracleAnalyticsPhysicalSchema("ORACLE_ANALYTICS_PHYSICAL_SCHEMA"),
        OracleAnalyticsPresentationTable("ORACLE_ANALYTICS_PRESENTATION_TABLE"),
        OracleAnalyticsLogicalTable("ORACLE_ANALYTICS_LOGICAL_TABLE"),
        OracleAnalyticsPhysicalTable("ORACLE_ANALYTICS_PHYSICAL_TABLE"),
        OracleAnalyticsAnalysis("ORACLE_ANALYTICS_ANALYSIS"),
        DatabaseSchema("DATABASE_SCHEMA"),
        Topic("TOPIC"),
        Connection("CONNECTION"),
        Glossary("GLOSSARY"),
        Term("TERM"),
        Category("CATEGORY"),
        File("FILE"),
        Bucket("BUCKET"),
        Message("MESSAGE"),
        UnrecognizedFile("UNRECOGNIZED_FILE");

        private final String value;
        private static Map<String, TypeName> map;

        private TypeName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TypeName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TypeName: " + key);
        }

        static {
            map = new HashMap<String, TypeName>();
            for (TypeName v : TypeName.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

