/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetJobExecutionRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String jobKey;
    private String jobExecutionKey;
    private List<Fields> fields;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public String getJobExecutionKey() {
        return this.jobExecutionKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).jobKey(this.jobKey).jobExecutionKey(this.jobExecutionKey).fields(this.fields).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",jobKey=").append(String.valueOf(this.jobKey));
        sb.append(",jobExecutionKey=").append(String.valueOf(this.jobExecutionKey));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJobExecutionRequest)) {
            return false;
        }
        GetJobExecutionRequest other = (GetJobExecutionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.jobKey, other.jobKey) && Objects.equals(this.jobExecutionKey, other.jobExecutionKey) && Objects.equals(this.fields, other.fields) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.jobKey == null ? 43 : this.jobKey.hashCode());
        result = result * 59 + (this.jobExecutionKey == null ? 43 : this.jobExecutionKey.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobExecutionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String jobKey = null;
        private String jobExecutionKey = null;
        private List<Fields> fields = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder jobExecutionKey(String jobExecutionKey) {
            this.jobExecutionKey = jobExecutionKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobExecutionRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.jobExecutionKey(o.getJobExecutionKey());
            this.fields(o.getFields());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobExecutionRequest build() {
            GetJobExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetJobExecutionRequest buildWithoutInvocationCallback() {
            GetJobExecutionRequest request = new GetJobExecutionRequest();
            request.catalogId = this.catalogId;
            request.jobKey = this.jobKey;
            request.jobExecutionKey = this.jobExecutionKey;
            request.fields = this.fields;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum Fields implements BmcEnum
    {
        Key("key"),
        JobKey("jobKey"),
        JobType("jobType"),
        SubType("subType"),
        ParentKey("parentKey"),
        ScheduleInstanceKey("scheduleInstanceKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        TimeStarted("timeStarted"),
        TimeEnded("timeEnded"),
        ErrorCode("errorCode"),
        ErrorMessage("errorMessage"),
        ProcessKey("processKey"),
        ExternalUrl("externalUrl"),
        EventKey("eventKey"),
        DataEntityKey("dataEntityKey"),
        CreatedById("createdById"),
        UpdatedById("updatedById"),
        Properties("properties"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

