/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCatalogPrivateEndpointRequest
extends BmcRequest<Void> {
    private String catalogPrivateEndpointId;
    private String opcRequestId;

    public String getCatalogPrivateEndpointId() {
        return this.catalogPrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogPrivateEndpointId(this.catalogPrivateEndpointId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogPrivateEndpointId=").append(String.valueOf(this.catalogPrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCatalogPrivateEndpointRequest)) {
            return false;
        }
        GetCatalogPrivateEndpointRequest other = (GetCatalogPrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogPrivateEndpointId, other.catalogPrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogPrivateEndpointId == null ? 43 : this.catalogPrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCatalogPrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogPrivateEndpointId = null;
        private String opcRequestId = null;

        public Builder catalogPrivateEndpointId(String catalogPrivateEndpointId) {
            this.catalogPrivateEndpointId = catalogPrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCatalogPrivateEndpointRequest o) {
            this.catalogPrivateEndpointId(o.getCatalogPrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCatalogPrivateEndpointRequest build() {
            GetCatalogPrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCatalogPrivateEndpointRequest buildWithoutInvocationCallback() {
            GetCatalogPrivateEndpointRequest request = new GetCatalogPrivateEndpointRequest();
            request.catalogPrivateEndpointId = this.catalogPrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

