/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteFolderTagRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String dataAssetKey;
    private String folderKey;
    private String tagKey;
    private String ifMatch;
    private String opcRequestId;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getFolderKey() {
        return this.folderKey;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).dataAssetKey(this.dataAssetKey).folderKey(this.folderKey).tagKey(this.tagKey).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(",folderKey=").append(String.valueOf(this.folderKey));
        sb.append(",tagKey=").append(String.valueOf(this.tagKey));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteFolderTagRequest)) {
            return false;
        }
        DeleteFolderTagRequest other = (DeleteFolderTagRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.folderKey, other.folderKey) && Objects.equals(this.tagKey, other.tagKey) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.folderKey == null ? 43 : this.folderKey.hashCode());
        result = result * 59 + (this.tagKey == null ? 43 : this.tagKey.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteFolderTagRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String dataAssetKey = null;
        private String folderKey = null;
        private String tagKey = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder folderKey(String folderKey) {
            this.folderKey = folderKey;
            return this;
        }

        public Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteFolderTagRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.folderKey(o.getFolderKey());
            this.tagKey(o.getTagKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteFolderTagRequest build() {
            DeleteFolderTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteFolderTagRequest buildWithoutInvocationCallback() {
            DeleteFolderTagRequest request = new DeleteFolderTagRequest();
            request.catalogId = this.catalogId;
            request.dataAssetKey = this.dataAssetKey;
            request.folderKey = this.folderKey;
            request.tagKey = this.tagKey;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

