/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateCustomPropertyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateCustomPropertyRequest
extends BmcRequest<CreateCustomPropertyDetails> {
    private String catalogId;
    private String namespaceId;
    private CreateCustomPropertyDetails createCustomPropertyDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public CreateCustomPropertyDetails getCreateCustomPropertyDetails() {
        return this.createCustomPropertyDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateCustomPropertyDetails getBody$() {
        return this.createCustomPropertyDetails;
    }

    public Builder toBuilder() {
        return new Builder().catalogId(this.catalogId).namespaceId(this.namespaceId).createCustomPropertyDetails(this.createCustomPropertyDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",catalogId=").append(String.valueOf(this.catalogId));
        sb.append(",namespaceId=").append(String.valueOf(this.namespaceId));
        sb.append(",createCustomPropertyDetails=").append(String.valueOf((Object)this.createCustomPropertyDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCustomPropertyRequest)) {
            return false;
        }
        CreateCustomPropertyRequest other = (CreateCustomPropertyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.catalogId, other.catalogId) && Objects.equals(this.namespaceId, other.namespaceId) && Objects.equals((Object)this.createCustomPropertyDetails, (Object)other.createCustomPropertyDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.namespaceId == null ? 43 : this.namespaceId.hashCode());
        result = result * 59 + (this.createCustomPropertyDetails == null ? 43 : this.createCustomPropertyDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateCustomPropertyRequest, CreateCustomPropertyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String catalogId = null;
        private String namespaceId = null;
        private CreateCustomPropertyDetails createCustomPropertyDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public Builder createCustomPropertyDetails(CreateCustomPropertyDetails createCustomPropertyDetails) {
            this.createCustomPropertyDetails = createCustomPropertyDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateCustomPropertyRequest o) {
            this.catalogId(o.getCatalogId());
            this.namespaceId(o.getNamespaceId());
            this.createCustomPropertyDetails(o.getCreateCustomPropertyDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateCustomPropertyRequest build() {
            CreateCustomPropertyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateCustomPropertyDetails body) {
            this.createCustomPropertyDetails(body);
            return this;
        }

        public CreateCustomPropertyRequest buildWithoutInvocationCallback() {
            CreateCustomPropertyRequest request = new CreateCustomPropertyRequest();
            request.catalogId = this.catalogId;
            request.namespaceId = this.namespaceId;
            request.createCustomPropertyDetails = this.createCustomPropertyDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

