/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.FacetedSearchAggregation;
import com.oracle.bmc.datacatalog.model.SearchResult;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SearchResultCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="count")
    private final Integer count;
    @JsonProperty(value="items")
    private final List<SearchResult> items;
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="facetedSearchAggregation")
    private final List<FacetedSearchAggregation> facetedSearchAggregation;
    @JsonProperty(value="sortableFields")
    private final List<String> sortableFields;

    @Deprecated
    @ConstructorProperties(value={"count", "items", "query", "facetedSearchAggregation", "sortableFields"})
    public SearchResultCollection(Integer count, List<SearchResult> items, String query, List<FacetedSearchAggregation> facetedSearchAggregation, List<String> sortableFields) {
        this.count = count;
        this.items = items;
        this.query = query;
        this.facetedSearchAggregation = facetedSearchAggregation;
        this.sortableFields = sortableFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getCount() {
        return this.count;
    }

    public List<SearchResult> getItems() {
        return this.items;
    }

    public String getQuery() {
        return this.query;
    }

    public List<FacetedSearchAggregation> getFacetedSearchAggregation() {
        return this.facetedSearchAggregation;
    }

    public List<String> getSortableFields() {
        return this.sortableFields;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchResultCollection(");
        sb.append("super=").append(super.toString());
        sb.append("count=").append(String.valueOf(this.count));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(", query=").append(String.valueOf(this.query));
        sb.append(", facetedSearchAggregation=").append(String.valueOf(this.facetedSearchAggregation));
        sb.append(", sortableFields=").append(String.valueOf(this.sortableFields));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResultCollection)) {
            return false;
        }
        SearchResultCollection other = (SearchResultCollection)((Object)o);
        return Objects.equals(this.count, other.count) && Objects.equals(this.items, other.items) && Objects.equals(this.query, other.query) && Objects.equals(this.facetedSearchAggregation, other.facetedSearchAggregation) && Objects.equals(this.sortableFields, other.sortableFields) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.facetedSearchAggregation == null ? 43 : this.facetedSearchAggregation.hashCode());
        result = result * 59 + (this.sortableFields == null ? 43 : this.sortableFields.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="count")
        private Integer count;
        @JsonProperty(value="items")
        private List<SearchResult> items;
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="facetedSearchAggregation")
        private List<FacetedSearchAggregation> facetedSearchAggregation;
        @JsonProperty(value="sortableFields")
        private List<String> sortableFields;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder items(List<SearchResult> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder facetedSearchAggregation(List<FacetedSearchAggregation> facetedSearchAggregation) {
            this.facetedSearchAggregation = facetedSearchAggregation;
            this.__explicitlySet__.add("facetedSearchAggregation");
            return this;
        }

        public Builder sortableFields(List<String> sortableFields) {
            this.sortableFields = sortableFields;
            this.__explicitlySet__.add("sortableFields");
            return this;
        }

        public SearchResultCollection build() {
            SearchResultCollection model = new SearchResultCollection(this.count, this.items, this.query, this.facetedSearchAggregation, this.sortableFields);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SearchResultCollection model) {
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("facetedSearchAggregation")) {
                this.facetedSearchAggregation(model.getFacetedSearchAggregation());
            }
            if (model.wasPropertyExplicitlySet("sortableFields")) {
                this.sortableFields(model.getSortableFields());
            }
            return this;
        }
    }
}

