/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.RecommendationResourceType;
import com.oracle.bmc.datacatalog.model.RecommendationStatus;
import com.oracle.bmc.datacatalog.model.RecommendationType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RecommendationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="recommendationKey")
    private final String recommendationKey;
    @JsonProperty(value="recommendationType")
    private final RecommendationType recommendationType;
    @JsonProperty(value="recommendationStatus")
    private final RecommendationStatus recommendationStatus;
    @JsonProperty(value="confidenceScore")
    private final Float confidenceScore;
    @JsonProperty(value="sourceObjectKey")
    private final String sourceObjectKey;
    @JsonProperty(value="sourceObjectName")
    private final String sourceObjectName;
    @JsonProperty(value="sourceObjectType")
    private final RecommendationResourceType sourceObjectType;
    @JsonProperty(value="targetObjectKey")
    private final String targetObjectKey;
    @JsonProperty(value="targetObjectName")
    private final String targetObjectName;
    @JsonProperty(value="targetObjectType")
    private final RecommendationResourceType targetObjectType;
    @JsonProperty(value="properties")
    private final Map<String, Map<String, String>> properties;

    @Deprecated
    @ConstructorProperties(value={"recommendationKey", "recommendationType", "recommendationStatus", "confidenceScore", "sourceObjectKey", "sourceObjectName", "sourceObjectType", "targetObjectKey", "targetObjectName", "targetObjectType", "properties"})
    public RecommendationDetails(String recommendationKey, RecommendationType recommendationType, RecommendationStatus recommendationStatus, Float confidenceScore, String sourceObjectKey, String sourceObjectName, RecommendationResourceType sourceObjectType, String targetObjectKey, String targetObjectName, RecommendationResourceType targetObjectType, Map<String, Map<String, String>> properties) {
        this.recommendationKey = recommendationKey;
        this.recommendationType = recommendationType;
        this.recommendationStatus = recommendationStatus;
        this.confidenceScore = confidenceScore;
        this.sourceObjectKey = sourceObjectKey;
        this.sourceObjectName = sourceObjectName;
        this.sourceObjectType = sourceObjectType;
        this.targetObjectKey = targetObjectKey;
        this.targetObjectName = targetObjectName;
        this.targetObjectType = targetObjectType;
        this.properties = properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRecommendationKey() {
        return this.recommendationKey;
    }

    public RecommendationType getRecommendationType() {
        return this.recommendationType;
    }

    public RecommendationStatus getRecommendationStatus() {
        return this.recommendationStatus;
    }

    public Float getConfidenceScore() {
        return this.confidenceScore;
    }

    public String getSourceObjectKey() {
        return this.sourceObjectKey;
    }

    public String getSourceObjectName() {
        return this.sourceObjectName;
    }

    public RecommendationResourceType getSourceObjectType() {
        return this.sourceObjectType;
    }

    public String getTargetObjectKey() {
        return this.targetObjectKey;
    }

    public String getTargetObjectName() {
        return this.targetObjectName;
    }

    public RecommendationResourceType getTargetObjectType() {
        return this.targetObjectType;
    }

    public Map<String, Map<String, String>> getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RecommendationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("recommendationKey=").append(String.valueOf(this.recommendationKey));
        sb.append(", recommendationType=").append(String.valueOf((Object)this.recommendationType));
        sb.append(", recommendationStatus=").append(String.valueOf((Object)this.recommendationStatus));
        sb.append(", confidenceScore=").append(String.valueOf(this.confidenceScore));
        sb.append(", sourceObjectKey=").append(String.valueOf(this.sourceObjectKey));
        sb.append(", sourceObjectName=").append(String.valueOf(this.sourceObjectName));
        sb.append(", sourceObjectType=").append(String.valueOf((Object)this.sourceObjectType));
        sb.append(", targetObjectKey=").append(String.valueOf(this.targetObjectKey));
        sb.append(", targetObjectName=").append(String.valueOf(this.targetObjectName));
        sb.append(", targetObjectType=").append(String.valueOf((Object)this.targetObjectType));
        sb.append(", properties=").append(String.valueOf(this.properties));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecommendationDetails)) {
            return false;
        }
        RecommendationDetails other = (RecommendationDetails)((Object)o);
        return Objects.equals(this.recommendationKey, other.recommendationKey) && Objects.equals((Object)this.recommendationType, (Object)other.recommendationType) && Objects.equals((Object)this.recommendationStatus, (Object)other.recommendationStatus) && Objects.equals(this.confidenceScore, other.confidenceScore) && Objects.equals(this.sourceObjectKey, other.sourceObjectKey) && Objects.equals(this.sourceObjectName, other.sourceObjectName) && Objects.equals((Object)this.sourceObjectType, (Object)other.sourceObjectType) && Objects.equals(this.targetObjectKey, other.targetObjectKey) && Objects.equals(this.targetObjectName, other.targetObjectName) && Objects.equals((Object)this.targetObjectType, (Object)other.targetObjectType) && Objects.equals(this.properties, other.properties) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.recommendationKey == null ? 43 : this.recommendationKey.hashCode());
        result = result * 59 + (this.recommendationType == null ? 43 : this.recommendationType.hashCode());
        result = result * 59 + (this.recommendationStatus == null ? 43 : this.recommendationStatus.hashCode());
        result = result * 59 + (this.confidenceScore == null ? 43 : this.confidenceScore.hashCode());
        result = result * 59 + (this.sourceObjectKey == null ? 43 : this.sourceObjectKey.hashCode());
        result = result * 59 + (this.sourceObjectName == null ? 43 : this.sourceObjectName.hashCode());
        result = result * 59 + (this.sourceObjectType == null ? 43 : this.sourceObjectType.hashCode());
        result = result * 59 + (this.targetObjectKey == null ? 43 : this.targetObjectKey.hashCode());
        result = result * 59 + (this.targetObjectName == null ? 43 : this.targetObjectName.hashCode());
        result = result * 59 + (this.targetObjectType == null ? 43 : this.targetObjectType.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="recommendationKey")
        private String recommendationKey;
        @JsonProperty(value="recommendationType")
        private RecommendationType recommendationType;
        @JsonProperty(value="recommendationStatus")
        private RecommendationStatus recommendationStatus;
        @JsonProperty(value="confidenceScore")
        private Float confidenceScore;
        @JsonProperty(value="sourceObjectKey")
        private String sourceObjectKey;
        @JsonProperty(value="sourceObjectName")
        private String sourceObjectName;
        @JsonProperty(value="sourceObjectType")
        private RecommendationResourceType sourceObjectType;
        @JsonProperty(value="targetObjectKey")
        private String targetObjectKey;
        @JsonProperty(value="targetObjectName")
        private String targetObjectName;
        @JsonProperty(value="targetObjectType")
        private RecommendationResourceType targetObjectType;
        @JsonProperty(value="properties")
        private Map<String, Map<String, String>> properties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder recommendationKey(String recommendationKey) {
            this.recommendationKey = recommendationKey;
            this.__explicitlySet__.add("recommendationKey");
            return this;
        }

        public Builder recommendationType(RecommendationType recommendationType) {
            this.recommendationType = recommendationType;
            this.__explicitlySet__.add("recommendationType");
            return this;
        }

        public Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            this.__explicitlySet__.add("recommendationStatus");
            return this;
        }

        public Builder confidenceScore(Float confidenceScore) {
            this.confidenceScore = confidenceScore;
            this.__explicitlySet__.add("confidenceScore");
            return this;
        }

        public Builder sourceObjectKey(String sourceObjectKey) {
            this.sourceObjectKey = sourceObjectKey;
            this.__explicitlySet__.add("sourceObjectKey");
            return this;
        }

        public Builder sourceObjectName(String sourceObjectName) {
            this.sourceObjectName = sourceObjectName;
            this.__explicitlySet__.add("sourceObjectName");
            return this;
        }

        public Builder sourceObjectType(RecommendationResourceType sourceObjectType) {
            this.sourceObjectType = sourceObjectType;
            this.__explicitlySet__.add("sourceObjectType");
            return this;
        }

        public Builder targetObjectKey(String targetObjectKey) {
            this.targetObjectKey = targetObjectKey;
            this.__explicitlySet__.add("targetObjectKey");
            return this;
        }

        public Builder targetObjectName(String targetObjectName) {
            this.targetObjectName = targetObjectName;
            this.__explicitlySet__.add("targetObjectName");
            return this;
        }

        public Builder targetObjectType(RecommendationResourceType targetObjectType) {
            this.targetObjectType = targetObjectType;
            this.__explicitlySet__.add("targetObjectType");
            return this;
        }

        public Builder properties(Map<String, Map<String, String>> properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public RecommendationDetails build() {
            RecommendationDetails model = new RecommendationDetails(this.recommendationKey, this.recommendationType, this.recommendationStatus, this.confidenceScore, this.sourceObjectKey, this.sourceObjectName, this.sourceObjectType, this.targetObjectKey, this.targetObjectName, this.targetObjectType, this.properties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RecommendationDetails model) {
            if (model.wasPropertyExplicitlySet("recommendationKey")) {
                this.recommendationKey(model.getRecommendationKey());
            }
            if (model.wasPropertyExplicitlySet("recommendationType")) {
                this.recommendationType(model.getRecommendationType());
            }
            if (model.wasPropertyExplicitlySet("recommendationStatus")) {
                this.recommendationStatus(model.getRecommendationStatus());
            }
            if (model.wasPropertyExplicitlySet("confidenceScore")) {
                this.confidenceScore(model.getConfidenceScore());
            }
            if (model.wasPropertyExplicitlySet("sourceObjectKey")) {
                this.sourceObjectKey(model.getSourceObjectKey());
            }
            if (model.wasPropertyExplicitlySet("sourceObjectName")) {
                this.sourceObjectName(model.getSourceObjectName());
            }
            if (model.wasPropertyExplicitlySet("sourceObjectType")) {
                this.sourceObjectType(model.getSourceObjectType());
            }
            if (model.wasPropertyExplicitlySet("targetObjectKey")) {
                this.targetObjectKey(model.getTargetObjectKey());
            }
            if (model.wasPropertyExplicitlySet("targetObjectName")) {
                this.targetObjectName(model.getTargetObjectName());
            }
            if (model.wasPropertyExplicitlySet("targetObjectType")) {
                this.targetObjectType(model.getTargetObjectType());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            return this;
        }
    }
}

