/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PropertyDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="isRequired")
    private final Boolean isRequired;
    @JsonProperty(value="isUpdatable")
    private final Boolean isUpdatable;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "isRequired", "isUpdatable"})
    public PropertyDefinition(String name, String type, Boolean isRequired, Boolean isUpdatable) {
        this.name = name;
        this.type = type;
        this.isRequired = isRequired;
        this.isUpdatable = isUpdatable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public Boolean getIsUpdatable() {
        return this.isUpdatable;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", isRequired=").append(String.valueOf(this.isRequired));
        sb.append(", isUpdatable=").append(String.valueOf(this.isUpdatable));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyDefinition)) {
            return false;
        }
        PropertyDefinition other = (PropertyDefinition)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.isRequired, other.isRequired) && Objects.equals(this.isUpdatable, other.isUpdatable) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.isRequired == null ? 43 : this.isRequired.hashCode());
        result = result * 59 + (this.isUpdatable == null ? 43 : this.isUpdatable.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="isRequired")
        private Boolean isRequired;
        @JsonProperty(value="isUpdatable")
        private Boolean isUpdatable;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.__explicitlySet__.add("isRequired");
            return this;
        }

        public Builder isUpdatable(Boolean isUpdatable) {
            this.isUpdatable = isUpdatable;
            this.__explicitlySet__.add("isUpdatable");
            return this;
        }

        public PropertyDefinition build() {
            PropertyDefinition model = new PropertyDefinition(this.name, this.type, this.isRequired, this.isUpdatable);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PropertyDefinition model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("isRequired")) {
                this.isRequired(model.getIsRequired());
            }
            if (model.wasPropertyExplicitlySet("isUpdatable")) {
                this.isUpdatable(model.getIsUpdatable());
            }
            return this;
        }
    }
}

